/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import io.gravitee.rest.api.model.permissions.RoleScope;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.EnumSet;
import lombok.Generated;

@Schema(enumAsRef=true)
public enum MembershipReferenceType {
    APPLICATION(EnumSet.of(RoleScope.APPLICATION)),
    API(EnumSet.of(RoleScope.API)),
    GROUP(EnumSet.of(RoleScope.GROUP, RoleScope.API, RoleScope.APPLICATION, RoleScope.INTEGRATION)),
    ENVIRONMENT(EnumSet.allOf(RoleScope.class)),
    ORGANIZATION(EnumSet.allOf(RoleScope.class)),
    PLATFORM(EnumSet.allOf(RoleScope.class)),
    INTEGRATION(EnumSet.allOf(RoleScope.class));

    private final EnumSet<RoleScope> roleScopes;

    public boolean allowedRoleScope(RoleScope scope) {
        return this.roleScopes.contains((Object)scope);
    }

    public RoleScope findScope() {
        return this.roleScopes.size() == 1 ? (RoleScope)((Object)this.roleScopes.iterator().next()) : this.roleScopes.stream().filter(scope -> scope.name().equals(this.name())).findFirst().orElse((RoleScope)((Object)this.roleScopes.iterator().next()));
    }

    @Generated
    private MembershipReferenceType(EnumSet<RoleScope> roleScopes) {
        this.roleScopes = roleScopes;
    }
}

