/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.v4.plan;

import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.rest.api.model.v4.plan.PlanValidationType;
import io.gravitee.rest.api.sanitizer.HtmlSanitizer;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;
import lombok.Generated;

@Schema(name="UpdatePlanEntityV4")
public class UpdatePlanEntity {
    private String id;
    private String crossId;
    @NotNull
    private String name;
    @NotNull
    private String description;
    @NotNull
    private PlanValidationType validation;
    private List<String> characteristics;
    @NotNull
    private int order;
    private List<String> excludedGroups;
    private PlanSecurity security;
    private boolean commentRequired;
    private String commentMessage;
    private String generalConditions;
    private String generalConditionsHrid;
    private Set<String> tags;
    private String selectionRule;
    private List<Flow> flows;

    public void setName(String name) {
        this.name = HtmlSanitizer.sanitize(name);
    }

    public void setDescription(String description) {
        this.description = HtmlSanitizer.sanitize(description);
    }

    @Generated
    public UpdatePlanEntity() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public PlanValidationType getValidation() {
        return this.validation;
    }

    @Generated
    public List<String> getCharacteristics() {
        return this.characteristics;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public List<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    @Generated
    public PlanSecurity getSecurity() {
        return this.security;
    }

    @Generated
    public boolean isCommentRequired() {
        return this.commentRequired;
    }

    @Generated
    public String getCommentMessage() {
        return this.commentMessage;
    }

    @Generated
    public String getGeneralConditions() {
        return this.generalConditions;
    }

    @Generated
    public String getGeneralConditionsHrid() {
        return this.generalConditionsHrid;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public String getSelectionRule() {
        return this.selectionRule;
    }

    @Generated
    public List<Flow> getFlows() {
        return this.flows;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setValidation(PlanValidationType validation) {
        this.validation = validation;
    }

    @Generated
    public void setCharacteristics(List<String> characteristics) {
        this.characteristics = characteristics;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setExcludedGroups(List<String> excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    @Generated
    public void setSecurity(PlanSecurity security) {
        this.security = security;
    }

    @Generated
    public void setCommentRequired(boolean commentRequired) {
        this.commentRequired = commentRequired;
    }

    @Generated
    public void setCommentMessage(String commentMessage) {
        this.commentMessage = commentMessage;
    }

    @Generated
    public void setGeneralConditions(String generalConditions) {
        this.generalConditions = generalConditions;
    }

    @Generated
    public void setGeneralConditionsHrid(String generalConditionsHrid) {
        this.generalConditionsHrid = generalConditionsHrid;
    }

    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setSelectionRule(String selectionRule) {
        this.selectionRule = selectionRule;
    }

    @Generated
    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    @Generated
    public String toString() {
        return "UpdatePlanEntity(id=" + this.getId() + ", crossId=" + this.getCrossId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", validation=" + String.valueOf((Object)this.getValidation()) + ", characteristics=" + String.valueOf(this.getCharacteristics()) + ", order=" + this.getOrder() + ", excludedGroups=" + String.valueOf(this.getExcludedGroups()) + ", security=" + String.valueOf(this.getSecurity()) + ", commentRequired=" + this.isCommentRequired() + ", commentMessage=" + this.getCommentMessage() + ", generalConditions=" + this.getGeneralConditions() + ", generalConditionsHrid=" + this.getGeneralConditionsHrid() + ", tags=" + String.valueOf(this.getTags()) + ", selectionRule=" + this.getSelectionRule() + ", flows=" + String.valueOf(this.getFlows()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdatePlanEntity)) {
            return false;
        }
        UpdatePlanEntity other = (UpdatePlanEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        if (this.isCommentRequired() != other.isCommentRequired()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$crossId = this.getCrossId();
        String other$crossId = other.getCrossId();
        if (this$crossId == null ? other$crossId != null : !this$crossId.equals(other$crossId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        PlanValidationType this$validation = this.getValidation();
        PlanValidationType other$validation = other.getValidation();
        if (this$validation == null ? other$validation != null : !((Object)((Object)this$validation)).equals((Object)other$validation)) {
            return false;
        }
        List<String> this$characteristics = this.getCharacteristics();
        List<String> other$characteristics = other.getCharacteristics();
        if (this$characteristics == null ? other$characteristics != null : !((Object)this$characteristics).equals(other$characteristics)) {
            return false;
        }
        List<String> this$excludedGroups = this.getExcludedGroups();
        List<String> other$excludedGroups = other.getExcludedGroups();
        if (this$excludedGroups == null ? other$excludedGroups != null : !((Object)this$excludedGroups).equals(other$excludedGroups)) {
            return false;
        }
        PlanSecurity this$security = this.getSecurity();
        PlanSecurity other$security = other.getSecurity();
        if (this$security == null ? other$security != null : !this$security.equals(other$security)) {
            return false;
        }
        String this$commentMessage = this.getCommentMessage();
        String other$commentMessage = other.getCommentMessage();
        if (this$commentMessage == null ? other$commentMessage != null : !this$commentMessage.equals(other$commentMessage)) {
            return false;
        }
        String this$generalConditions = this.getGeneralConditions();
        String other$generalConditions = other.getGeneralConditions();
        if (this$generalConditions == null ? other$generalConditions != null : !this$generalConditions.equals(other$generalConditions)) {
            return false;
        }
        String this$generalConditionsHrid = this.getGeneralConditionsHrid();
        String other$generalConditionsHrid = other.getGeneralConditionsHrid();
        if (this$generalConditionsHrid == null ? other$generalConditionsHrid != null : !this$generalConditionsHrid.equals(other$generalConditionsHrid)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$selectionRule = this.getSelectionRule();
        String other$selectionRule = other.getSelectionRule();
        if (this$selectionRule == null ? other$selectionRule != null : !this$selectionRule.equals(other$selectionRule)) {
            return false;
        }
        List<Flow> this$flows = this.getFlows();
        List<Flow> other$flows = other.getFlows();
        return !(this$flows == null ? other$flows != null : !((Object)this$flows).equals(other$flows));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpdatePlanEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOrder();
        result = result * 59 + (this.isCommentRequired() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $crossId = this.getCrossId();
        result = result * 59 + ($crossId == null ? 43 : $crossId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        PlanValidationType $validation = this.getValidation();
        result = result * 59 + ($validation == null ? 43 : ((Object)((Object)$validation)).hashCode());
        List<String> $characteristics = this.getCharacteristics();
        result = result * 59 + ($characteristics == null ? 43 : ((Object)$characteristics).hashCode());
        List<String> $excludedGroups = this.getExcludedGroups();
        result = result * 59 + ($excludedGroups == null ? 43 : ((Object)$excludedGroups).hashCode());
        PlanSecurity $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : $security.hashCode());
        String $commentMessage = this.getCommentMessage();
        result = result * 59 + ($commentMessage == null ? 43 : $commentMessage.hashCode());
        String $generalConditions = this.getGeneralConditions();
        result = result * 59 + ($generalConditions == null ? 43 : $generalConditions.hashCode());
        String $generalConditionsHrid = this.getGeneralConditionsHrid();
        result = result * 59 + ($generalConditionsHrid == null ? 43 : $generalConditionsHrid.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $selectionRule = this.getSelectionRule();
        result = result * 59 + ($selectionRule == null ? 43 : $selectionRule.hashCode());
        List<Flow> $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : ((Object)$flows).hashCode());
        return result;
    }
}

