/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.settings.logging;

import io.gravitee.definition.model.v4.analytics.sampling.Sampling;
import io.gravitee.rest.api.model.settings.logging.MessageSampling;
import io.gravitee.rest.api.model.settings.logging.ValidMessageSamplingSettings;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.time.Duration;

public class MessageSamplingSettingsValidator
implements ConstraintValidator<ValidMessageSamplingSettings, MessageSampling> {
    public boolean isValid(MessageSampling messageSampling, ConstraintValidatorContext constraintValidatorContext) {
        boolean validCountSettings = MessageSamplingSettingsValidator.validateCountSettings(messageSampling, constraintValidatorContext);
        boolean validProbabilisticSettings = MessageSamplingSettingsValidator.validateProbabilisticSettings(messageSampling, constraintValidatorContext);
        boolean validTemporalSettings = MessageSamplingSettingsValidator.validateTemporalSettings(messageSampling, constraintValidatorContext);
        boolean validWindowedCountSettings = this.validateWindowedCountSettings(messageSampling, constraintValidatorContext);
        return validCountSettings && validProbabilisticSettings && validTemporalSettings && validWindowedCountSettings;
    }

    private static boolean validateCountSettings(MessageSampling messageSampling, ConstraintValidatorContext constraintValidatorContext) {
        MessageSampling.Count count = messageSampling.getCount();
        if (count.getDefaultValue() < count.getLimit()) {
            constraintValidatorContext.buildConstraintViolationWithTemplate("Invalid count default value, 'default' should be greater than 'limit'").addConstraintViolation();
            return false;
        }
        return true;
    }

    private static boolean validateProbabilisticSettings(MessageSampling messageSampling, ConstraintValidatorContext constraintValidatorContext) {
        MessageSampling.Probabilistic probabilistic = messageSampling.getProbabilistic();
        if (probabilistic.getDefaultValue() > probabilistic.getLimit()) {
            constraintValidatorContext.buildConstraintViolationWithTemplate("Invalid probabilistic default value, 'default' should be lower than 'limit'").addConstraintViolation();
            return false;
        }
        return true;
    }

    private static boolean validateTemporalSettings(MessageSampling messageSampling, ConstraintValidatorContext constraintValidatorContext) {
        MessageSampling.Temporal temporal = messageSampling.getTemporal();
        boolean hasValidationConstraint = false;
        Duration defaultDuration = null;
        Duration limitDuration = null;
        try {
            defaultDuration = Duration.parse(temporal.getDefaultValue());
        }
        catch (Exception e) {
            constraintValidatorContext.buildConstraintViolationWithTemplate("Invalid temporal default value, 'default' should be a valid ISO-8601 date").addConstraintViolation();
            hasValidationConstraint = true;
        }
        try {
            limitDuration = Duration.parse(temporal.getLimit());
        }
        catch (Exception e) {
            constraintValidatorContext.buildConstraintViolationWithTemplate("Invalid temporal limit value, 'limit' should be a valid ISO-8601 date").addConstraintViolation();
            hasValidationConstraint = true;
        }
        if (defaultDuration != null && limitDuration != null && defaultDuration.getSeconds() < limitDuration.getSeconds()) {
            constraintValidatorContext.buildConstraintViolationWithTemplate("Invalid temporal default value, 'default' should be greater than 'limit'").addConstraintViolation();
            hasValidationConstraint = true;
        }
        return !hasValidationConstraint;
    }

    private boolean validateWindowedCountSettings(MessageSampling messageSampling, ConstraintValidatorContext constraintValidatorContext) {
        MessageSampling.WindowedCount windowedCount = messageSampling.getWindowedCount();
        boolean hasValidationConstraint = false;
        Sampling.WindowedCount defaultValue = null;
        Sampling.WindowedCount limit = null;
        try {
            defaultValue = Sampling.parseWindowedCount((String)windowedCount.getDefaultValue());
        }
        catch (Exception e) {
            constraintValidatorContext.buildConstraintViolationWithTemplate("Invalid windowed count 'default' value: cannot parse").addConstraintViolation();
            hasValidationConstraint = true;
        }
        if (defaultValue != null && defaultValue.count() < 0) {
            constraintValidatorContext.buildConstraintViolationWithTemplate("Invalid windowed count 'default' value: count must be positive").addConstraintViolation();
            hasValidationConstraint = true;
        }
        try {
            limit = Sampling.parseWindowedCount((String)windowedCount.getLimit());
        }
        catch (Exception e) {
            constraintValidatorContext.buildConstraintViolationWithTemplate("Invalid windowed count 'limit' value: cannot parse").addConstraintViolation();
            hasValidationConstraint = true;
        }
        if (limit != null && limit.count() < 0) {
            constraintValidatorContext.buildConstraintViolationWithTemplate("Invalid windowed count 'limit' value: count must be positive").addConstraintViolation();
            return false;
        }
        if (defaultValue != null && limit != null && defaultValue.ratePerSeconds() > limit.ratePerSeconds()) {
            constraintValidatorContext.buildConstraintViolationWithTemplate("Invalid windowed count default value, 'default' should have a lower rate than 'limit'").addConstraintViolation();
            hasValidationConstraint = true;
        }
        return !hasValidationConstraint;
    }
}

