/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.v4.api;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.analytics.Analytics;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.execution.FlowExecution;
import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.definition.model.v4.resource.Resource;
import io.gravitee.definition.model.v4.service.ApiServices;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.DeploymentRequired;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.v4.api.properties.PropertyEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

@Schema(name="UpdateApiEntityV4")
public class UpdateApiEntity {
    @Schema(description="API's uuid.", example="00f8c9e7-78fc-4907-b8c9-e778fc790750")
    private String id;
    @Schema(description="API's crossId. Identifies API across environments.", example="00f8c9e7-78fc-4907-b8c9-e778fc790750")
    private String crossId;
    @NotBlank
    @NotEmpty(message="API's name must not be empty")
    @Schema(description="API's name. Duplicate names can exists.", example="My Api")
    private @NotBlank @NotEmpty(message="API's name must not be empty") String name;
    @NotBlank
    @Schema(description="Api's version. It's a simple string only used in the portal.", example="v1.0")
    private String apiVersion;
    @NotNull
    @Schema(description="API's gravitee definition version")
    private DefinitionVersion definitionVersion;
    @NotNull
    @Schema(description="API's type", example="async")
    private ApiType type;
    @NotNull
    @Schema(description="API's description. A short description of your API.", example="I can use a hundred characters to describe this API.")
    private String description;
    @Schema(description="The list of sharding tags associated with this API.", example="public, private")
    @DeploymentRequired
    private Set<String> tags = new HashSet<String>();
    @NotNull
    @Valid
    @Schema(description="A list of listeners used to describe our you api could be reached.")
    @DeploymentRequired
    private @NotNull @Valid List<@NotNull Listener> listeners;
    @NotNull
    @Valid
    @Schema(description="A list of endpoint describing the endpoints to contact.")
    @DeploymentRequired
    private List<EndpointGroup> endpointGroups;
    @NotNull
    @Valid
    @Schema(description="Analytics configuration")
    @DeploymentRequired
    private Analytics analytics;
    @Schema(description="A dictionary (could be dynamic) of properties available in the API context.")
    @DeploymentRequired
    private List<PropertyEntity> properties = new ArrayList<PropertyEntity>();
    @Schema(description="The list of API resources used by policies like cache resources or oauth2")
    @DeploymentRequired
    private List<Resource> resources = new ArrayList<Resource>();
    @Schema(description="A list of plans to apply on the API")
    @DeploymentRequired
    private Set<PlanEntity> plans = new HashSet<PlanEntity>();
    @Schema(description="API's flow execution.")
    @DeploymentRequired
    private FlowExecution flowExecution;
    @Valid
    @Schema(description="A list of flows containing the policies configuration.")
    @DeploymentRequired
    private List<Flow> flows;
    @Valid
    @DeploymentRequired
    @Schema(description="A map that allows you to configure the output of a request based on the event throws by the gateway. Example : Quota exceeded, api-key is missing, ...")
    private Map<String, Map<String, ResponseTemplate>> responseTemplates = new LinkedHashMap<String, Map<String, ResponseTemplate>>();
    @Valid
    @DeploymentRequired
    @Schema(description="The configuration of API services like the dynamic properties.")
    private ApiServices services;
    @Schema(description="API's groups. Used to add team in your API.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<@NotBlank String> groups;
    @NotNull
    @Schema(description="The visibility of the API regarding the portal.", example="PUBLIC")
    private Visibility visibility;
    @Schema(description="the API logo encoded in base64")
    private String picture;
    @Schema(description="the API logo URL.", example="https://gravitee.mycompany.com/management/apis/6c530064-0b2c-4004-9300-640b2ce0047b/picture")
    private String pictureUrl;
    @Schema(description="the list of categories associated with this API", example="Product, Customer, Misc")
    private Set<String> categories;
    @Schema(description="the free list of labels associated with this API", example="json, read_only, awesome")
    private List<String> labels;
    private List<ApiMetadataEntity> metadata;
    private ApiLifecycleState lifecycleState;
    private boolean disableMembershipNotifications;
    @Schema(description="the API background encoded in base64")
    private String background;
    @Schema(description="the API background url.", example="https://gravitee.mycompany.com/management/apis/6c530064-0b2c-4004-9300-640b2ce0047b/background")
    private String backgroundUrl;

    @Generated
    public UpdateApiEntity() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Generated
    public DefinitionVersion getDefinitionVersion() {
        return this.definitionVersion;
    }

    @Generated
    public ApiType getType() {
        return this.type;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public List<@NotNull Listener> getListeners() {
        return this.listeners;
    }

    @Generated
    public List<EndpointGroup> getEndpointGroups() {
        return this.endpointGroups;
    }

    @Generated
    public Analytics getAnalytics() {
        return this.analytics;
    }

    @Generated
    public List<PropertyEntity> getProperties() {
        return this.properties;
    }

    @Generated
    public List<Resource> getResources() {
        return this.resources;
    }

    @Generated
    public Set<PlanEntity> getPlans() {
        return this.plans;
    }

    @Generated
    public FlowExecution getFlowExecution() {
        return this.flowExecution;
    }

    @Generated
    public List<Flow> getFlows() {
        return this.flows;
    }

    @Generated
    public Map<String, Map<String, ResponseTemplate>> getResponseTemplates() {
        return this.responseTemplates;
    }

    @Generated
    public ApiServices getServices() {
        return this.services;
    }

    @Generated
    public Set<@NotBlank String> getGroups() {
        return this.groups;
    }

    @Generated
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Generated
    public String getPicture() {
        return this.picture;
    }

    @Generated
    public String getPictureUrl() {
        return this.pictureUrl;
    }

    @Generated
    public Set<String> getCategories() {
        return this.categories;
    }

    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Generated
    public List<ApiMetadataEntity> getMetadata() {
        return this.metadata;
    }

    @Generated
    public ApiLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    @Generated
    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    @Generated
    public String getBackground() {
        return this.background;
    }

    @Generated
    public String getBackgroundUrl() {
        return this.backgroundUrl;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Generated
    public void setDefinitionVersion(DefinitionVersion definitionVersion) {
        this.definitionVersion = definitionVersion;
    }

    @Generated
    public void setType(ApiType type) {
        this.type = type;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setListeners(List<@NotNull Listener> listeners) {
        this.listeners = listeners;
    }

    @Generated
    public void setEndpointGroups(List<EndpointGroup> endpointGroups) {
        this.endpointGroups = endpointGroups;
    }

    @Generated
    public void setAnalytics(Analytics analytics) {
        this.analytics = analytics;
    }

    @Generated
    public void setProperties(List<PropertyEntity> properties) {
        this.properties = properties;
    }

    @Generated
    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    @Generated
    public void setPlans(Set<PlanEntity> plans) {
        this.plans = plans;
    }

    @Generated
    public void setFlowExecution(FlowExecution flowExecution) {
        this.flowExecution = flowExecution;
    }

    @Generated
    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    @Generated
    public void setResponseTemplates(Map<String, Map<String, ResponseTemplate>> responseTemplates) {
        this.responseTemplates = responseTemplates;
    }

    @Generated
    public void setServices(ApiServices services) {
        this.services = services;
    }

    @Generated
    public void setGroups(Set<@NotBlank String> groups) {
        this.groups = groups;
    }

    @Generated
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Generated
    public void setPicture(String picture) {
        this.picture = picture;
    }

    @Generated
    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    @Generated
    public void setCategories(Set<String> categories) {
        this.categories = categories;
    }

    @Generated
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Generated
    public void setMetadata(List<ApiMetadataEntity> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setLifecycleState(ApiLifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @Generated
    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    @Generated
    public void setBackground(String background) {
        this.background = background;
    }

    @Generated
    public void setBackgroundUrl(String backgroundUrl) {
        this.backgroundUrl = backgroundUrl;
    }

    @Generated
    public String toString() {
        return "UpdateApiEntity(id=" + this.getId() + ", crossId=" + this.getCrossId() + ", name=" + this.getName() + ", apiVersion=" + this.getApiVersion() + ", definitionVersion=" + this.getDefinitionVersion() + ", type=" + this.getType() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", listeners=" + this.getListeners() + ", endpointGroups=" + this.getEndpointGroups() + ", analytics=" + this.getAnalytics() + ", properties=" + this.getProperties() + ", resources=" + this.getResources() + ", plans=" + this.getPlans() + ", flowExecution=" + this.getFlowExecution() + ", flows=" + this.getFlows() + ", responseTemplates=" + this.getResponseTemplates() + ", services=" + this.getServices() + ", groups=" + this.getGroups() + ", visibility=" + this.getVisibility() + ", picture=" + this.getPicture() + ", pictureUrl=" + this.getPictureUrl() + ", categories=" + this.getCategories() + ", labels=" + this.getLabels() + ", metadata=" + this.getMetadata() + ", lifecycleState=" + this.getLifecycleState() + ", disableMembershipNotifications=" + this.isDisableMembershipNotifications() + ", background=" + this.getBackground() + ", backgroundUrl=" + this.getBackgroundUrl() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateApiEntity)) {
            return false;
        }
        UpdateApiEntity other = (UpdateApiEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDisableMembershipNotifications() != other.isDisableMembershipNotifications()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$crossId = this.getCrossId();
        String other$crossId = other.getCrossId();
        if (this$crossId == null ? other$crossId != null : !this$crossId.equals(other$crossId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        DefinitionVersion this$definitionVersion = this.getDefinitionVersion();
        DefinitionVersion other$definitionVersion = other.getDefinitionVersion();
        if (this$definitionVersion == null ? other$definitionVersion != null : !this$definitionVersion.equals(other$definitionVersion)) {
            return false;
        }
        ApiType this$type = this.getType();
        ApiType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<Listener> this$listeners = this.getListeners();
        List<Listener> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        List<EndpointGroup> this$endpointGroups = this.getEndpointGroups();
        List<EndpointGroup> other$endpointGroups = other.getEndpointGroups();
        if (this$endpointGroups == null ? other$endpointGroups != null : !((Object)this$endpointGroups).equals(other$endpointGroups)) {
            return false;
        }
        Analytics this$analytics = this.getAnalytics();
        Analytics other$analytics = other.getAnalytics();
        if (this$analytics == null ? other$analytics != null : !this$analytics.equals(other$analytics)) {
            return false;
        }
        List<PropertyEntity> this$properties = this.getProperties();
        List<PropertyEntity> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<Resource> this$resources = this.getResources();
        List<Resource> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Set<PlanEntity> this$plans = this.getPlans();
        Set<PlanEntity> other$plans = other.getPlans();
        if (this$plans == null ? other$plans != null : !((Object)this$plans).equals(other$plans)) {
            return false;
        }
        FlowExecution this$flowExecution = this.getFlowExecution();
        FlowExecution other$flowExecution = other.getFlowExecution();
        if (this$flowExecution == null ? other$flowExecution != null : !this$flowExecution.equals(other$flowExecution)) {
            return false;
        }
        List<Flow> this$flows = this.getFlows();
        List<Flow> other$flows = other.getFlows();
        if (this$flows == null ? other$flows != null : !((Object)this$flows).equals(other$flows)) {
            return false;
        }
        Map<String, Map<String, ResponseTemplate>> this$responseTemplates = this.getResponseTemplates();
        Map<String, Map<String, ResponseTemplate>> other$responseTemplates = other.getResponseTemplates();
        if (this$responseTemplates == null ? other$responseTemplates != null : !((Object)this$responseTemplates).equals(other$responseTemplates)) {
            return false;
        }
        ApiServices this$services = this.getServices();
        ApiServices other$services = other.getServices();
        if (this$services == null ? other$services != null : !this$services.equals(other$services)) {
            return false;
        }
        Set<String> this$groups = this.getGroups();
        Set<String> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        Visibility this$visibility = this.getVisibility();
        Visibility other$visibility = other.getVisibility();
        if (this$visibility == null ? other$visibility != null : !((Object)((Object)this$visibility)).equals((Object)other$visibility)) {
            return false;
        }
        String this$picture = this.getPicture();
        String other$picture = other.getPicture();
        if (this$picture == null ? other$picture != null : !this$picture.equals(other$picture)) {
            return false;
        }
        String this$pictureUrl = this.getPictureUrl();
        String other$pictureUrl = other.getPictureUrl();
        if (this$pictureUrl == null ? other$pictureUrl != null : !this$pictureUrl.equals(other$pictureUrl)) {
            return false;
        }
        Set<String> this$categories = this.getCategories();
        Set<String> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        List<String> this$labels = this.getLabels();
        List<String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        List<ApiMetadataEntity> this$metadata = this.getMetadata();
        List<ApiMetadataEntity> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        ApiLifecycleState this$lifecycleState = this.getLifecycleState();
        ApiLifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$background = this.getBackground();
        String other$background = other.getBackground();
        if (this$background == null ? other$background != null : !this$background.equals(other$background)) {
            return false;
        }
        String this$backgroundUrl = this.getBackgroundUrl();
        String other$backgroundUrl = other.getBackgroundUrl();
        return !(this$backgroundUrl == null ? other$backgroundUrl != null : !this$backgroundUrl.equals(other$backgroundUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpdateApiEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisableMembershipNotifications() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $crossId = this.getCrossId();
        result = result * 59 + ($crossId == null ? 43 : $crossId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        DefinitionVersion $definitionVersion = this.getDefinitionVersion();
        result = result * 59 + ($definitionVersion == null ? 43 : $definitionVersion.hashCode());
        ApiType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<Listener> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        List<EndpointGroup> $endpointGroups = this.getEndpointGroups();
        result = result * 59 + ($endpointGroups == null ? 43 : ((Object)$endpointGroups).hashCode());
        Analytics $analytics = this.getAnalytics();
        result = result * 59 + ($analytics == null ? 43 : $analytics.hashCode());
        List<PropertyEntity> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<Resource> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Set<PlanEntity> $plans = this.getPlans();
        result = result * 59 + ($plans == null ? 43 : ((Object)$plans).hashCode());
        FlowExecution $flowExecution = this.getFlowExecution();
        result = result * 59 + ($flowExecution == null ? 43 : $flowExecution.hashCode());
        List<Flow> $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : ((Object)$flows).hashCode());
        Map<String, Map<String, ResponseTemplate>> $responseTemplates = this.getResponseTemplates();
        result = result * 59 + ($responseTemplates == null ? 43 : ((Object)$responseTemplates).hashCode());
        ApiServices $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : $services.hashCode());
        Set<String> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        Visibility $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : ((Object)((Object)$visibility)).hashCode());
        String $picture = this.getPicture();
        result = result * 59 + ($picture == null ? 43 : $picture.hashCode());
        String $pictureUrl = this.getPictureUrl();
        result = result * 59 + ($pictureUrl == null ? 43 : $pictureUrl.hashCode());
        Set<String> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        List<String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        List<ApiMetadataEntity> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        ApiLifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $background = this.getBackground();
        result = result * 59 + ($background == null ? 43 : $background.hashCode());
        String $backgroundUrl = this.getBackgroundUrl();
        result = result * 59 + ($backgroundUrl == null ? 43 : $backgroundUrl.hashCode());
        return result;
    }
}

