/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.api;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.ExecutionMode;
import io.gravitee.definition.model.FlowMode;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.definition.model.services.Services;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.DeploymentRequired;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PropertiesEntity;
import io.gravitee.rest.api.model.PropertyEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.jackson.PropertiesEntityAsListDeserializer;
import io.gravitee.rest.api.sanitizer.HtmlSanitizer;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class UpdateApiEntity {
    @Schema(description="API's crossId. Identifies API across environments.", example="00f8c9e7-78fc-4907-b8c9-e778fc790750")
    private String crossId;
    @NotNull
    @NotEmpty(message="Api's name must not be empty")
    @Schema(description="Api's name. Duplicate names can exists.", example="My Api")
    private @NotNull @NotEmpty(message="Api's name must not be empty") String name;
    @NotNull
    @Schema(description="Api's version. It's a simple string only used in the portal.", example="v1.0")
    private String version;
    @NotNull
    @Schema(description="API's description. A short description of your API.", example="I can use a hundred characters to describe this API.")
    private String description;
    @Schema(description="Api's execution mode. Define if the execution mode should use v3 or jupiter mode.", example="v3")
    @DeploymentRequired
    @JsonProperty(value="execution_mode")
    private ExecutionMode executionMode;
    @NotNull
    @JsonProperty(value="proxy", required=true)
    @Schema(description="API's definition.")
    private Proxy proxy;
    @JsonProperty(value="paths")
    @Schema(description="a map where you can associate a path to a configuration (the policies configuration)")
    private Map<String, List<Rule>> paths = new HashMap<String, List<Rule>>();
    @JsonProperty(value="flows")
    @Schema(description="a list of flows (the policies configuration)")
    private List<Flow> flows = new ArrayList<Flow>();
    @JsonProperty(value="plans")
    @Schema(description="a list of plans with flows (the policies configuration)")
    private Set<PlanEntity> plans = new HashSet<PlanEntity>();
    @Schema(description="The configuration of API services like the dynamic properties, the endpoint discovery or the healthcheck.")
    private Services services;
    @Schema(description="The list of API resources used by policies like cache resources or oauth2")
    private List<Resource> resources = new ArrayList<Resource>();
    @JsonProperty(value="properties")
    @Schema(description="A dictionary (could be dynamic) of properties available in the API context.")
    private PropertiesEntity properties;
    @NotNull
    @Schema(description="The visibility of the API regarding the portal.", example="PUBLIC")
    private Visibility visibility;
    @Schema(description="the list of sharding tags associated with this API.", example="public, private")
    private Set<String> tags;
    @Schema(description="the API logo encoded in base64")
    private String picture;
    @DeploymentRequired
    @JsonProperty(value="gravitee", required=false)
    @Schema(description="API's gravitee definition version")
    private String graviteeDefinitionVersion;
    @DeploymentRequired
    @JsonProperty(value="flow_mode")
    @Schema(description="API's flow mode.", example="BEST_MATCH")
    private FlowMode flowMode;
    @JsonProperty(value="picture_url")
    @Schema(description="the API logo URL")
    private String pictureUrl;
    @Schema(description="the list of categories associated with this API", example="Product, Customer, Misc")
    private Set<String> categories;
    @Schema(description="the free list of labels associated with this API", example="json, read_only, awesome")
    private List<String> labels;
    @Schema(description="API's groups. Used to add team in your API.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    @JsonProperty(value="path_mappings")
    @Schema(description="A list of paths used to aggregate data in analytics", example="/products/:productId, /products/:productId/media")
    private Set<String> pathMappings;
    @JsonProperty(value="response_templates")
    @Schema(description="A map that allows you to configure the output of a request based on the event throws by the gateway. Example : Quota exceeded, api-ky is missing, ...")
    private Map<String, Map<String, ResponseTemplate>> responseTemplates;
    private List<ApiMetadataEntity> metadata;
    @JsonProperty(value="lifecycle_state")
    private ApiLifecycleState lifecycleState;
    @JsonProperty(value="disable_membership_notifications")
    private boolean disableMembershipNotifications;
    @Schema(description="the API background encoded in base64")
    private String background;
    @JsonProperty(value="background_url")
    @Schema(description="the API background URL")
    private String backgroundUrl;
    @Schema(hidden=true, description="The API's lifecycle state has been added for the kubernetes operator only.")
    private Lifecycle.State state;

    public void setName(String name) {
        this.name = HtmlSanitizer.sanitize(name);
    }

    @JsonIgnore
    public void setProperties(PropertiesEntity properties) {
        this.properties = properties;
    }

    @JsonSetter(value="properties")
    @JsonDeserialize(using=PropertiesEntityAsListDeserializer.class)
    public void setPropertyList(List<PropertyEntity> properties) {
        this.properties = new PropertiesEntity(properties);
    }

    @JsonGetter(value="properties")
    public List<PropertyEntity> getPropertyList() {
        if (this.properties != null) {
            return this.properties.getProperties();
        }
        return Collections.emptyList();
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    @Generated
    public Proxy getProxy() {
        return this.proxy;
    }

    @Generated
    public Map<String, List<Rule>> getPaths() {
        return this.paths;
    }

    @Generated
    public List<Flow> getFlows() {
        return this.flows;
    }

    @Generated
    public Set<PlanEntity> getPlans() {
        return this.plans;
    }

    @Generated
    public Services getServices() {
        return this.services;
    }

    @Generated
    public List<Resource> getResources() {
        return this.resources;
    }

    @Generated
    public PropertiesEntity getProperties() {
        return this.properties;
    }

    @Generated
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public String getPicture() {
        return this.picture;
    }

    @Generated
    public String getGraviteeDefinitionVersion() {
        return this.graviteeDefinitionVersion;
    }

    @Generated
    public FlowMode getFlowMode() {
        return this.flowMode;
    }

    @Generated
    public String getPictureUrl() {
        return this.pictureUrl;
    }

    @Generated
    public Set<String> getCategories() {
        return this.categories;
    }

    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Generated
    public Set<String> getGroups() {
        return this.groups;
    }

    @Generated
    public Set<String> getPathMappings() {
        return this.pathMappings;
    }

    @Generated
    public Map<String, Map<String, ResponseTemplate>> getResponseTemplates() {
        return this.responseTemplates;
    }

    @Generated
    public List<ApiMetadataEntity> getMetadata() {
        return this.metadata;
    }

    @Generated
    public ApiLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    @Generated
    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    @Generated
    public String getBackground() {
        return this.background;
    }

    @Generated
    public String getBackgroundUrl() {
        return this.backgroundUrl;
    }

    @Generated
    public Lifecycle.State getState() {
        return this.state;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="execution_mode")
    @Generated
    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    @JsonProperty(value="proxy", required=true)
    @Generated
    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @JsonProperty(value="paths")
    @Generated
    public void setPaths(Map<String, List<Rule>> paths) {
        this.paths = paths;
    }

    @JsonProperty(value="flows")
    @Generated
    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    @JsonProperty(value="plans")
    @Generated
    public void setPlans(Set<PlanEntity> plans) {
        this.plans = plans;
    }

    @Generated
    public void setServices(Services services) {
        this.services = services;
    }

    @Generated
    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    @Generated
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setPicture(String picture) {
        this.picture = picture;
    }

    @JsonProperty(value="gravitee", required=false)
    @Generated
    public void setGraviteeDefinitionVersion(String graviteeDefinitionVersion) {
        this.graviteeDefinitionVersion = graviteeDefinitionVersion;
    }

    @JsonProperty(value="flow_mode")
    @Generated
    public void setFlowMode(FlowMode flowMode) {
        this.flowMode = flowMode;
    }

    @JsonProperty(value="picture_url")
    @Generated
    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    @Generated
    public void setCategories(Set<String> categories) {
        this.categories = categories;
    }

    @Generated
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Generated
    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @JsonProperty(value="path_mappings")
    @Generated
    public void setPathMappings(Set<String> pathMappings) {
        this.pathMappings = pathMappings;
    }

    @JsonProperty(value="response_templates")
    @Generated
    public void setResponseTemplates(Map<String, Map<String, ResponseTemplate>> responseTemplates) {
        this.responseTemplates = responseTemplates;
    }

    @Generated
    public void setMetadata(List<ApiMetadataEntity> metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="lifecycle_state")
    @Generated
    public void setLifecycleState(ApiLifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @JsonProperty(value="disable_membership_notifications")
    @Generated
    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    @Generated
    public void setBackground(String background) {
        this.background = background;
    }

    @JsonProperty(value="background_url")
    @Generated
    public void setBackgroundUrl(String backgroundUrl) {
        this.backgroundUrl = backgroundUrl;
    }

    @Generated
    public void setState(Lifecycle.State state) {
        this.state = state;
    }
}

