/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.rest.api.model.ApiKeyMode;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.gravitee.rest.api.sanitizer.HtmlSanitizer;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UpdateApplicationEntity {
    @NotNull(message="Application's name must not be null")
    @NotEmpty(message="Application's name must not be empty")
    @Schema(description="Application's name. Duplicate names can exists.", example="My App")
    private @NotNull(message="Application's name must not be null") @NotEmpty(message="Application's name must not be empty") String name;
    @NotNull(message="Application's description must not be null")
    @Schema(description="Application's description. A short description of your App.", example="I can use a hundred characters to describe this App.")
    private @NotNull(message="Application's description must not be null") String description;
    @Schema(description="Domain used by the application, if relevant", example="https://my-app.com")
    private String domain;
    private String picture;
    @JsonProperty(value="picture_url")
    private String pictureUrl;
    @NotNull(message="Application's settings must not be null")
    private @NotNull(message="Application's settings must not be null") ApplicationSettings settings;
    @Schema(description="Application groups. Used to add teams to your application.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    @Deprecated
    @Schema(description="a string to describe the type of your app.", example="iOS")
    private String type;
    @Deprecated
    private String clientId;
    @JsonProperty(value="disable_membership_notifications")
    private boolean disableMembershipNotifications;
    @JsonProperty(value="api_key_mode")
    @Schema(description="The API key mode used for this application.")
    private ApiKeyMode apiKeyMode;
    private String background;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = HtmlSanitizer.sanitize(name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = HtmlSanitizer.sanitize(description);
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public ApplicationSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ApplicationSettings settings) {
        this.settings = settings;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public ApiKeyMode getApiKeyMode() {
        return this.apiKeyMode;
    }

    public void setApiKeyMode(ApiKeyMode apiKeyMode) {
        this.apiKeyMode = apiKeyMode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Application{");
        sb.append("description='").append(this.description).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", groups='").append(this.groups).append('\'');
        sb.append(", disableMembershipNotifications='").append(this.disableMembershipNotifications);
        sb.append('}');
        return sb.toString();
    }

    @Generated
    public static UpdateApplicationEntityBuilder builder() {
        return new UpdateApplicationEntityBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateApplicationEntity)) {
            return false;
        }
        UpdateApplicationEntity other = (UpdateApplicationEntity)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpdateApplicationEntity;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public UpdateApplicationEntity() {
    }

    @Generated
    public UpdateApplicationEntity(@NotNull(message="Application's name must not be null") @NotNull(message="Application's name must not be null") String name, @NotNull(message="Application's description must not be null") @NotNull(message="Application's description must not be null") String description, String domain, String picture, String pictureUrl, @NotNull(message="Application's settings must not be null") @NotNull(message="Application's settings must not be null") ApplicationSettings settings, Set<String> groups, String type, String clientId, boolean disableMembershipNotifications, ApiKeyMode apiKeyMode, String background) {
        this.name = name;
        this.description = description;
        this.domain = domain;
        this.picture = picture;
        this.pictureUrl = pictureUrl;
        this.settings = settings;
        this.groups = groups;
        this.type = type;
        this.clientId = clientId;
        this.disableMembershipNotifications = disableMembershipNotifications;
        this.apiKeyMode = apiKeyMode;
        this.background = background;
    }

    @Generated
    public static class UpdateApplicationEntityBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String domain;
        @Generated
        private String picture;
        @Generated
        private String pictureUrl;
        @Generated
        private ApplicationSettings settings;
        @Generated
        private Set<String> groups;
        @Generated
        private String type;
        @Generated
        private String clientId;
        @Generated
        private boolean disableMembershipNotifications;
        @Generated
        private ApiKeyMode apiKeyMode;
        @Generated
        private String background;

        @Generated
        UpdateApplicationEntityBuilder() {
        }

        @Generated
        public UpdateApplicationEntityBuilder name(@NotNull(message="Application's name must not be null") @NotNull(message="Application's name must not be null") String name) {
            this.name = name;
            return this;
        }

        @Generated
        public UpdateApplicationEntityBuilder description(@NotNull(message="Application's description must not be null") @NotNull(message="Application's description must not be null") String description) {
            this.description = description;
            return this;
        }

        @Generated
        public UpdateApplicationEntityBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public UpdateApplicationEntityBuilder picture(String picture) {
            this.picture = picture;
            return this;
        }

        @JsonProperty(value="picture_url")
        @Generated
        public UpdateApplicationEntityBuilder pictureUrl(String pictureUrl) {
            this.pictureUrl = pictureUrl;
            return this;
        }

        @Generated
        public UpdateApplicationEntityBuilder settings(@NotNull(message="Application's settings must not be null") @NotNull(message="Application's settings must not be null") ApplicationSettings settings) {
            this.settings = settings;
            return this;
        }

        @Generated
        public UpdateApplicationEntityBuilder groups(Set<String> groups) {
            this.groups = groups;
            return this;
        }

        @Deprecated
        @Generated
        public UpdateApplicationEntityBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Deprecated
        @Generated
        public UpdateApplicationEntityBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @JsonProperty(value="disable_membership_notifications")
        @Generated
        public UpdateApplicationEntityBuilder disableMembershipNotifications(boolean disableMembershipNotifications) {
            this.disableMembershipNotifications = disableMembershipNotifications;
            return this;
        }

        @JsonProperty(value="api_key_mode")
        @Generated
        public UpdateApplicationEntityBuilder apiKeyMode(ApiKeyMode apiKeyMode) {
            this.apiKeyMode = apiKeyMode;
            return this;
        }

        @Generated
        public UpdateApplicationEntityBuilder background(String background) {
            this.background = background;
            return this;
        }

        @Generated
        public UpdateApplicationEntity build() {
            return new UpdateApplicationEntity(this.name, this.description, this.domain, this.picture, this.pictureUrl, this.settings, this.groups, this.type, this.clientId, this.disableMembershipNotifications, this.apiKeyMode, this.background);
        }

        @Generated
        public String toString() {
            return "UpdateApplicationEntity.UpdateApplicationEntityBuilder(name=" + this.name + ", description=" + this.description + ", domain=" + this.domain + ", picture=" + this.picture + ", pictureUrl=" + this.pictureUrl + ", settings=" + this.settings + ", groups=" + this.groups + ", type=" + this.type + ", clientId=" + this.clientId + ", disableMembershipNotifications=" + this.disableMembershipNotifications + ", apiKeyMode=" + this.apiKeyMode + ", background=" + this.background + ")";
        }
    }
}

