/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.api;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.FlowMode;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.Properties;
import io.gravitee.definition.model.Property;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.definition.model.services.Services;
import io.gravitee.rest.api.model.DeploymentRequired;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiEntrypointEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.search.Indexable;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotNull;

@JsonFilter(value="apiMembershipTypeFilter")
public class ApiEntity
implements Indexable {
    @Schema(description="API's uuid.", example="00f8c9e7-78fc-4907-b8c9-e778fc790750")
    private String id;
    @Schema(description="API's crossId. Identifies API across environments.", example="df83b2a4-cc3e-3f80-9f0d-c138c106c076")
    private String crossId;
    @Schema(description="API's name. Duplicate names can exists.", example="My Api")
    private String name;
    @Schema(description="Api's version. It's a simple string only used in the portal.", example="v1.0")
    private String version;
    @Schema(description="API's description. A short description of your API.", example="I can use a hundred characters to describe this API.")
    private String description;
    @Schema(description="API's groups. Used to add team in your API.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    @JsonProperty(value="context_path")
    @Schema(description="API's context path.", example="/my-awesome-api")
    private String contextPath;
    @NotNull
    @DeploymentRequired
    @JsonProperty(value="proxy", required=true)
    @Schema(description="API's definition.")
    private Proxy proxy;
    @DeploymentRequired
    @JsonProperty(value="flow_mode")
    @Schema(description="API's flow mode.", example="BEST_MATCH")
    private FlowMode flowMode;
    @DeploymentRequired
    @JsonProperty(value="paths", required=true)
    @Schema(description="a map where you can associate a path to a configuration (the policies configuration)")
    private Map<String, List<Rule>> paths = new HashMap<String, List<Rule>>();
    @DeploymentRequired
    @JsonProperty(value="flows", required=true)
    @Schema(description="a list of flows (the policies configuration)")
    private List<Flow> flows = new ArrayList<Flow>();
    @DeploymentRequired
    @JsonProperty(value="plans", required=true)
    @Schema(description="a list of plans with flows (the policies configuration)")
    private List<Plan> plans = new ArrayList<Plan>();
    @DeploymentRequired
    @JsonProperty(value="gravitee", required=false)
    @Schema(description="API's gravitee definition version")
    private String graviteeDefinitionVersion;
    @JsonProperty(value="deployed_at")
    @Schema(description="The last date (as timestamp) when the API was deployed.", example="1581256457163")
    private Date deployedAt;
    @JsonProperty(value="created_at")
    @Schema(description="The date (as a timestamp) when the API was created.", example="1581256457163")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @Schema(description="The last date (as a timestamp) when the API was updated.", example="1581256457163")
    private Date updatedAt;
    @Schema(description="The visibility of the API regarding the portal.", example="PUBLIC")
    private Visibility visibility;
    @Schema(description="The status of the API regarding the gateway.", example="STARTED")
    private Lifecycle.State state;
    @JsonProperty(value="owner")
    @Schema(description="The user with role PRIMARY_OWNER on this API.")
    private PrimaryOwnerEntity primaryOwner;
    @DeploymentRequired
    @JsonProperty(value="properties")
    @Schema(description="A dictionary (could be dynamic) of properties available in the API context.")
    private Properties properties;
    @DeploymentRequired
    @JsonProperty(value="services")
    @Schema(description="The configuration of API services like the dynamic properties, the endpoint discovery or the healthcheck.")
    private Services services;
    @DeploymentRequired
    @Schema(description="the list of sharding tags associated with this API.", example="public, private")
    private Set<String> tags;
    @Schema(description="the API logo encoded in base64")
    private String picture;
    @JsonProperty(value="picture_url")
    @Schema(description="the API logo url.", example="https://gravitee.mycompany.com/management/apis/6c530064-0b2c-4004-9300-640b2ce0047b/picture")
    private String pictureUrl;
    @DeploymentRequired
    @JsonProperty(value="resources")
    @Schema(description="The list of API resources used by policies like cache resources or oauth2")
    private List<Resource> resources = new ArrayList<Resource>();
    @Schema(description="the list of categories associated with this API", example="Product, Customer, Misc")
    private Set<String> categories;
    @Schema(description="the free list of labels associated with this API", example="json, read_only, awesome")
    private List<String> labels;
    @DeploymentRequired
    @JsonProperty(value="path_mappings")
    @Schema(description="A list of paths used to aggregate data in analytics", example="/products/:productId, /products/:productId/media")
    private Set<String> pathMappings = new HashSet<String>();
    @JsonIgnore
    private Map<String, Object> metadata = new HashMap<String, Object>();
    @DeploymentRequired
    @JsonProperty(value="response_templates")
    @Schema(description="A map that allows you to configure the output of a request based on the event throws by the gateway. Example : Quota exceeded, api-ky is missing, ...")
    private Map<String, Map<String, ResponseTemplate>> responseTemplates;
    @JsonProperty(value="lifecycle_state")
    private ApiLifecycleState lifecycleState;
    @JsonProperty(value="workflow_state")
    private WorkflowState workflowState;
    @JsonProperty(value="disable_membership_notifications")
    private boolean disableMembershipNotifications;
    private List<ApiEntrypointEntity> entrypoints;
    @Schema(description="the API background encoded in base64")
    private String background;
    @JsonProperty(value="background_url")
    @Schema(description="the API background url.", example="https://gravitee.mycompany.com/management/apis/6c530064-0b2c-4004-9300-640b2ce0047b/background")
    private String backgroundUrl;
    @JsonIgnore
    private String referenceType;
    @JsonIgnore
    private String referenceId;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getReferenceType() {
        return this.referenceType;
    }

    @Override
    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    @Override
    public String getReferenceId() {
        return this.referenceId;
    }

    @Override
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Lifecycle.State getState() {
        return this.state;
    }

    public void setState(Lifecycle.State state) {
        this.state = state;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Map<String, List<Rule>> getPaths() {
        return this.paths;
    }

    public void setPaths(Map<String, List<Rule>> paths) {
        this.paths = paths;
    }

    public PrimaryOwnerEntity getPrimaryOwner() {
        return this.primaryOwner;
    }

    public void setPrimaryOwner(PrimaryOwnerEntity primaryOwner) {
        this.primaryOwner = primaryOwner;
    }

    public Services getServices() {
        return this.services;
    }

    public void setServices(Services services) {
        this.services = services;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @JsonIgnore
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @JsonSetter(value="properties")
    public void setPropertyList(List<Property> properties) {
        this.properties = new Properties();
        this.properties.setProperties(properties);
    }

    @JsonGetter(value="properties")
    public List<Property> getPropertyList() {
        if (this.properties != null) {
            return this.properties.getProperties();
        }
        return Collections.emptyList();
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public Date getDeployedAt() {
        return this.deployedAt;
    }

    public void setDeployedAt(Date deployedAt) {
        this.deployedAt = deployedAt;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public void setCategories(Set<String> categories) {
        this.categories = categories;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public Set<String> getPathMappings() {
        return this.pathMappings;
    }

    public void setPathMappings(Set<String> pathMappings) {
        this.pathMappings = pathMappings;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public Map<String, Map<String, ResponseTemplate>> getResponseTemplates() {
        return this.responseTemplates;
    }

    public void setResponseTemplates(Map<String, Map<String, ResponseTemplate>> responseTemplates) {
        this.responseTemplates = responseTemplates;
    }

    public ApiLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public void setLifecycleState(ApiLifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }

    public void setWorkflowState(WorkflowState workflowState) {
        this.workflowState = workflowState;
    }

    public List<ApiEntrypointEntity> getEntrypoints() {
        return this.entrypoints;
    }

    public void setEntrypoints(List<ApiEntrypointEntity> entrypoints) {
        this.entrypoints = entrypoints;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public String getBackgroundUrl() {
        return this.backgroundUrl;
    }

    public void setBackgroundUrl(String backgroundUrl) {
        this.backgroundUrl = backgroundUrl;
    }

    public List<Flow> getFlows() {
        return this.flows;
    }

    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    public List<Plan> getPlans() {
        return this.plans;
    }

    public void setPlans(List<Plan> plans) {
        this.plans = plans;
    }

    public String getGraviteeDefinitionVersion() {
        return this.graviteeDefinitionVersion;
    }

    public void setGraviteeDefinitionVersion(String graviteeDefinitionVersion) {
        this.graviteeDefinitionVersion = graviteeDefinitionVersion;
    }

    public FlowMode getFlowMode() {
        return this.flowMode;
    }

    public void setFlowMode(FlowMode flowMode) {
        this.flowMode = flowMode;
    }

    public String getCrossId() {
        return this.crossId;
    }

    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiEntity api = (ApiEntity)o;
        return Objects.equals(this.id, api.id) && Objects.equals(this.version, api.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version);
    }

    public String toString() {
        return "ApiEntity{id='" + this.id + "', crossId='" + this.crossId + "', name='" + this.name + "', version='" + this.version + "', description='" + this.description + "', proxy=" + this.proxy + ", paths=" + this.paths + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", visibility=" + this.visibility + ", state=" + this.state + ", primaryOwner=" + this.primaryOwner + ", tags=" + this.tags + ", category=" + this.categories + ", groups=" + this.groups + ", pathMappings=" + this.pathMappings + ", lifecycleState=" + this.lifecycleState + ", workflowState=" + this.workflowState + ", disableMembershipNotifications=" + this.disableMembershipNotifications + ", graviteeDefinitionVersion=" + this.graviteeDefinitionVersion + ", flowMode=" + this.flowMode + "}";
    }
}

