/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import java.util.Set;

public class ApplicationEntity {
    @ApiModelProperty(value="Application's uuid.", example="00f8c9e7-78fc-4907-b8c9-e778fc790750")
    private String id;
    @ApiModelProperty(value="Application's name. Duplicate names can exists.", example="My App")
    private String name;
    @ApiModelProperty(value="Application's description. A short description of your App.", example="I can use a hundred characters to describe this App.")
    private String description;
    @ApiModelProperty(value="Domain used by the application, if relevant", example="https://my-app.com")
    private String domain;
    @ApiModelProperty(value="Application groups. Used to add teams to your application.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    @ApiModelProperty(value="if the app is ACTIVE or ARCHIVED.", example="ACTIVE")
    private String status;
    @ApiModelProperty(value="a string to describe the type of your app.", example="iOS")
    private String type;
    private String picture;
    @JsonProperty(value="created_at")
    @ApiModelProperty(value="The date (as a timestamp) when the application was created.", example="1581256457163")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @ApiModelProperty(value="The last date (as a timestamp) when the application was updated.", example="1581256457163")
    private Date updatedAt;
    @JsonProperty(value="owner")
    @ApiModelProperty(value="The user with role PRIMARY_OWNER on this API.")
    private PrimaryOwnerEntity primaryOwner;
    @JsonProperty(value="settings")
    private ApplicationSettings settings;
    @JsonProperty(value="disable_membership_notifications")
    private boolean disableMembershipNotifications;
    private String background;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public PrimaryOwnerEntity getPrimaryOwner() {
        return this.primaryOwner;
    }

    public void setPrimaryOwner(PrimaryOwnerEntity primaryOwner) {
        this.primaryOwner = primaryOwner;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ApplicationSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ApplicationSettings settings) {
        this.settings = settings;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationEntity that = (ApplicationEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Application{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", createdAt=").append(this.createdAt).append('\'');
        sb.append(", disableMembershipNotifications='").append(this.disableMembershipNotifications);
        sb.append('}');
        return sb.toString();
    }
}

