/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.rest.api.automation.security.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.core.access_point.query_service.AccessPointQueryService;
import io.gravitee.apim.core.installation.domain_service.InstallationTypeDomainService;
import io.gravitee.apim.core.installation.query_service.InstallationAccessQueryService;
import io.gravitee.apim.rest.api.automation.security.config.GraviteeUrlBasedCorsConfigurationSource;
import io.gravitee.common.event.EventManager;
import io.gravitee.rest.api.idp.api.IdentityProvider;
import io.gravitee.rest.api.idp.api.authentication.AuthenticationProvider;
import io.gravitee.rest.api.idp.core.plugin.IdentityProviderManager;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.security.authentication.AuthenticationProviderManager;
import io.gravitee.rest.api.security.authentication.GraviteeAuthenticationDetails;
import io.gravitee.rest.api.security.cookies.CookieGenerator;
import io.gravitee.rest.api.security.csrf.CookieCsrfSignedTokenRepository;
import io.gravitee.rest.api.security.csrf.CsrfRequestMatcher;
import io.gravitee.rest.api.security.filter.CsrfIncludeFilter;
import io.gravitee.rest.api.security.filter.GraviteeContextAuthorizationFilter;
import io.gravitee.rest.api.security.filter.GraviteeContextFilter;
import io.gravitee.rest.api.security.filter.TokenAuthenticationFilter;
import io.gravitee.rest.api.security.listener.AuthenticationFailureListener;
import io.gravitee.rest.api.security.listener.AuthenticationSuccessListener;
import io.gravitee.rest.api.security.utils.AuthoritiesProvider;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.ReCaptchaService;
import io.gravitee.rest.api.service.TokenService;
import io.gravitee.rest.api.service.UserService;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfigurationSource;

@Configuration
@Profile(value={"basic"})
@EnableWebSecurity
public class BasicSecurityConfigurerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasicSecurityConfigurerAdapter.class);
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private IdentityProviderManager identityProviderManager;
    @Autowired
    private AuthenticationProviderManager authenticationProviderManager;
    @Autowired
    private CookieGenerator cookieGenerator;
    @Autowired
    private ReCaptchaService reCaptchaService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private AuthoritiesProvider authoritiesProvider;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private EventManager eventManager;
    @Autowired
    private AccessPointQueryService accessPointQueryService;
    @Autowired
    private InstallationAccessQueryService installationAccessQueryService;
    @Autowired
    private InstallationTypeDomainService installationTypeDomainService;
    @Autowired
    private EnvironmentService environmentService;

    @Bean
    public AuthenticationSuccessListener authenticationSuccessListener() {
        return new AuthenticationSuccessListener();
    }

    @Bean
    public AuthenticationFailureListener authenticationFailureListener() {
        return new AuthenticationFailureListener();
    }

    @Bean
    public CookieCsrfSignedTokenRepository cookieCsrfSignedTokenRepository() {
        return new CookieCsrfSignedTokenRepository();
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        return new GraviteeUrlBasedCorsConfigurationSource((Environment)this.environment, this.parameterService, this.installationAccessQueryService, this.eventManager, ParameterReferenceType.ORGANIZATION);
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        String jwtSecret = this.environment.getProperty("jwt.secret");
        if (jwtSecret == null || jwtSecret.isEmpty()) {
            throw new IllegalStateException("JWT secret is mandatory");
        }
        if ("myJWT4Gr4v1t33_S3cr3t".equals(jwtSecret)) {
            log.warn("");
            log.warn("##############################################################");
            log.warn("#                      SECURITY WARNING                      #");
            log.warn("##############################################################");
            log.warn("");
            log.warn("You still use the default jwt secret.");
            log.warn("This known secret can be used to impersonate anyone.");
            log.warn("Please change this value, or ask your administrator to do it !");
            log.warn("");
            log.warn("##############################################################");
            log.warn("");
        }
        this.authenticationManager(http);
        this.authentication(http);
        this.session(http);
        this.authorizations(http);
        this.hsts(http);
        this.csrf(http);
        http.addFilterBefore((Filter)new TokenAuthenticationFilter(jwtSecret, this.cookieGenerator, this.userService, this.tokenService, this.authoritiesProvider), BasicAuthenticationFilter.class);
        http.addFilterBefore((Filter)new GraviteeContextFilter(this.installationTypeDomainService, this.accessPointQueryService, this.environmentService), CsrfFilter.class);
        http.addFilterAfter((Filter)new GraviteeContextAuthorizationFilter(), AuthorizationFilter.class);
        return (SecurityFilterChain)http.build();
    }

    private void authenticationManager(HttpSecurity http) throws Exception {
        AuthenticationManagerBuilder auth = (AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class);
        log.info("--------------------------------------------------------------");
        log.info("Management API BasicSecurity Config");
        log.info("Loading authentication identity providers for Basic authentication");
        List providers = this.authenticationProviderManager.getIdentityProviders().stream().filter(authenticationProvider -> !authenticationProvider.external()).collect(Collectors.toList());
        for (io.gravitee.rest.api.security.authentication.AuthenticationProvider provider : providers) {
            log.info("Loading authentication provider of type {} at position {}", (Object)provider.type(), (Object)provider.index());
            boolean found = false;
            Collection identityProviders = this.identityProviderManager.getAll();
            for (IdentityProvider identityProvider : identityProviders) {
                AuthenticationProvider authenticationProviderPlugin;
                if (!identityProvider.type().equalsIgnoreCase(provider.type()) || (authenticationProviderPlugin = this.identityProviderManager.loadIdentityProvider(identityProvider.type(), provider.configuration())) == null) continue;
                Object authenticationProvider2 = authenticationProviderPlugin.configure();
                if (authenticationProvider2 instanceof org.springframework.security.authentication.AuthenticationProvider) {
                    auth.authenticationProvider((org.springframework.security.authentication.AuthenticationProvider)authenticationProvider2);
                } else if (authenticationProvider2 instanceof SecurityConfigurer) {
                    auth.apply((SecurityConfigurer)authenticationProvider2);
                }
                found = true;
                break;
            }
            if (found) continue;
            log.error("No authentication provider found for type: {}", (Object)provider.type());
        }
        log.info("--------------------------------------------------------------");
    }

    private HttpSecurity authentication(HttpSecurity security) throws Exception {
        return (HttpSecurity)security.httpBasic().authenticationDetailsSource(this.authenticationDetailsSource()).realmName("Gravitee.io Management API").and();
    }

    private HttpSecurity session(HttpSecurity security) throws Exception {
        return (HttpSecurity)security.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and();
    }

    private HttpSecurity authorizations(HttpSecurity security) throws Exception {
        String uriOrgPrefix = "/organizations/**";
        String uriPrefix = uriOrgPrefix + "/environments/**";
        return (HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)security.authorizeHttpRequests().requestMatchers(HttpMethod.GET, new String[]{"/"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/open-api.yaml"})).permitAll().requestMatchers(HttpMethod.OPTIONS, new String[]{"**"})).permitAll().anyRequest()).authenticated().and();
    }

    private AuthenticationDetailsSource<HttpServletRequest, GraviteeAuthenticationDetails> authenticationDetailsSource() {
        return GraviteeAuthenticationDetails::new;
    }

    private HttpSecurity hsts(HttpSecurity security) throws Exception {
        HeadersConfigurer.HstsConfig hstsConfig = security.headers().httpStrictTransportSecurity();
        Boolean hstsEnabled = (Boolean)this.environment.getProperty("http.hsts.enabled", Boolean.class, (Object)true);
        if (hstsEnabled.booleanValue()) {
            return (HttpSecurity)hstsConfig.includeSubDomains(((Boolean)this.environment.getProperty("http.hsts.include-sub-domains", Boolean.class, (Object)true)).booleanValue()).maxAgeInSeconds(((Long)this.environment.getProperty("http.hsts.max-age", Long.class, (Object)31536000L)).longValue()).and().and();
        }
        return (HttpSecurity)hstsConfig.disable().and();
    }

    private HttpSecurity csrf(HttpSecurity security) throws Exception {
        if (((Boolean)this.environment.getProperty("http.csrf.enabled", Boolean.class, (Object)false)).booleanValue()) {
            CsrfTokenRequestAttributeHandler requestHandler = new CsrfTokenRequestAttributeHandler();
            requestHandler.setCsrfRequestAttributeName(null);
            CookieCsrfSignedTokenRepository csrfTokenRepository = this.cookieCsrfSignedTokenRepository();
            return security.csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)csrfTokenRepository).requireCsrfProtectionMatcher((RequestMatcher)new CsrfRequestMatcher()).csrfTokenRequestHandler((CsrfTokenRequestHandler)requestHandler).sessionAuthenticationStrategy((authentication, request, response) -> csrfTokenRepository.saveToken((CsrfToken)request.getAttribute(CsrfToken.class.getName()), request, response))).addFilterAfter((Filter)new CsrfIncludeFilter(), CsrfFilter.class);
        }
        return security.csrf(AbstractHttpConfigurer::disable);
    }
}

