/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.model;

import io.gravitee.common.utils.TimeProvider;
import jakarta.annotation.Nullable;
import java.util.Date;
import lombok.Generated;

public class AsyncJob {
    String id;
    String sourceId;
    String environmentId;
    String initiatorId;
    String type;
    Date createdAt;
    Date updatedAt;
    @Nullable
    Date deadLine;
    String status;
    String errorMessage;
    Long upperLimit;

    public boolean isLate() {
        return "PENDING".equalsIgnoreCase(this.status) && this.deadLine != null && this.deadLine.before(Date.from(TimeProvider.instantNow()));
    }

    public boolean isTimedOut() {
        return "TIMEOUT".equalsIgnoreCase(this.status);
    }

    @Generated
    public static AsyncJobBuilder builder() {
        return new AsyncJobBuilder();
    }

    @Generated
    public AsyncJobBuilder toBuilder() {
        return new AsyncJobBuilder().id(this.id).sourceId(this.sourceId).environmentId(this.environmentId).initiatorId(this.initiatorId).type(this.type).createdAt(this.createdAt).updatedAt(this.updatedAt).deadLine(this.deadLine).status(this.status).errorMessage(this.errorMessage).upperLimit(this.upperLimit);
    }

    @Generated
    public AsyncJob() {
    }

    @Generated
    public AsyncJob(String id, String sourceId, String environmentId, String initiatorId, String type, Date createdAt, Date updatedAt, @Nullable Date deadLine, String status, String errorMessage, Long upperLimit) {
        this.id = id;
        this.sourceId = sourceId;
        this.environmentId = environmentId;
        this.initiatorId = initiatorId;
        this.type = type;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.deadLine = deadLine;
        this.status = status;
        this.errorMessage = errorMessage;
        this.upperLimit = upperLimit;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getSourceId() {
        return this.sourceId;
    }

    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Generated
    public String getInitiatorId() {
        return this.initiatorId;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    @Generated
    public Date getDeadLine() {
        return this.deadLine;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public Long getUpperLimit() {
        return this.upperLimit;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    @Generated
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Generated
    public void setInitiatorId(String initiatorId) {
        this.initiatorId = initiatorId;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setDeadLine(@Nullable Date deadLine) {
        this.deadLine = deadLine;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setUpperLimit(Long upperLimit) {
        this.upperLimit = upperLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncJob)) {
            return false;
        }
        AsyncJob other = (AsyncJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$upperLimit = this.getUpperLimit();
        Long other$upperLimit = other.getUpperLimit();
        if (this$upperLimit == null ? other$upperLimit != null : !((Object)this$upperLimit).equals(other$upperLimit)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$sourceId = this.getSourceId();
        String other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId)) {
            return false;
        }
        String this$environmentId = this.getEnvironmentId();
        String other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !this$environmentId.equals(other$environmentId)) {
            return false;
        }
        String this$initiatorId = this.getInitiatorId();
        String other$initiatorId = other.getInitiatorId();
        if (this$initiatorId == null ? other$initiatorId != null : !this$initiatorId.equals(other$initiatorId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Date this$deadLine = this.getDeadLine();
        Date other$deadLine = other.getDeadLine();
        if (this$deadLine == null ? other$deadLine != null : !((Object)this$deadLine).equals(other$deadLine)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AsyncJob;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $upperLimit = this.getUpperLimit();
        result = result * 59 + ($upperLimit == null ? 43 : ((Object)$upperLimit).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : $sourceId.hashCode());
        String $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : $environmentId.hashCode());
        String $initiatorId = this.getInitiatorId();
        result = result * 59 + ($initiatorId == null ? 43 : $initiatorId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Date $deadLine = this.getDeadLine();
        result = result * 59 + ($deadLine == null ? 43 : ((Object)$deadLine).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AsyncJob(id=" + this.getId() + ", sourceId=" + this.getSourceId() + ", environmentId=" + this.getEnvironmentId() + ", initiatorId=" + this.getInitiatorId() + ", type=" + this.getType() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", deadLine=" + String.valueOf(this.getDeadLine()) + ", status=" + this.getStatus() + ", errorMessage=" + this.getErrorMessage() + ", upperLimit=" + this.getUpperLimit() + ")";
    }

    @Generated
    public static class AsyncJobBuilder {
        @Generated
        private String id;
        @Generated
        private String sourceId;
        @Generated
        private String environmentId;
        @Generated
        private String initiatorId;
        @Generated
        private String type;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private Date deadLine;
        @Generated
        private String status;
        @Generated
        private String errorMessage;
        @Generated
        private Long upperLimit;

        @Generated
        AsyncJobBuilder() {
        }

        @Generated
        public AsyncJobBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public AsyncJobBuilder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        @Generated
        public AsyncJobBuilder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Generated
        public AsyncJobBuilder initiatorId(String initiatorId) {
            this.initiatorId = initiatorId;
            return this;
        }

        @Generated
        public AsyncJobBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public AsyncJobBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public AsyncJobBuilder updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public AsyncJobBuilder deadLine(@Nullable Date deadLine) {
            this.deadLine = deadLine;
            return this;
        }

        @Generated
        public AsyncJobBuilder status(String status) {
            this.status = status;
            return this;
        }

        @Generated
        public AsyncJobBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Generated
        public AsyncJobBuilder upperLimit(Long upperLimit) {
            this.upperLimit = upperLimit;
            return this;
        }

        @Generated
        public AsyncJob build() {
            return new AsyncJob(this.id, this.sourceId, this.environmentId, this.initiatorId, this.type, this.createdAt, this.updatedAt, this.deadLine, this.status, this.errorMessage, this.upperLimit);
        }

        @Generated
        public String toString() {
            return "AsyncJob.AsyncJobBuilder(id=" + this.id + ", sourceId=" + this.sourceId + ", environmentId=" + this.environmentId + ", initiatorId=" + this.initiatorId + ", type=" + this.type + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", deadLine=" + String.valueOf(this.deadLine) + ", status=" + this.status + ", errorMessage=" + this.errorMessage + ", upperLimit=" + this.upperLimit + ")";
        }
    }
}

