/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.model;

import io.gravitee.repository.management.model.Audit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class ApiKey
implements Serializable {
    private String id;
    private String key;
    private List<String> subscriptions = new ArrayList<String>();
    private String environmentId;
    @Deprecated(since="3.17.0", forRemoval=true)
    private String subscription;
    @Deprecated(since="3.17.0", forRemoval=true)
    private String plan;
    @Deprecated(since="3.17.0", forRemoval=true)
    private String api;
    private String application;
    private Date expireAt;
    private Date createdAt;
    private Date updatedAt;
    private boolean revoked;
    private boolean paused;
    private Date revokedAt;
    private boolean federated;
    private Integer daysToExpirationOnLastNotification;

    public ApiKey(ApiKey cloned) {
        this.id = cloned.id;
        this.key = cloned.key;
        this.subscriptions = cloned.subscriptions;
        this.subscription = cloned.subscription;
        this.application = cloned.application;
        this.plan = cloned.plan;
        this.expireAt = cloned.expireAt;
        this.createdAt = cloned.createdAt;
        this.updatedAt = cloned.updatedAt;
        this.revoked = cloned.revoked;
        this.revokedAt = cloned.revokedAt;
        this.paused = cloned.paused;
        this.federated = cloned.federated;
        this.daysToExpirationOnLastNotification = cloned.daysToExpirationOnLastNotification;
        this.api = cloned.api;
        this.environmentId = cloned.environmentId;
    }

    public ApiKey revoke() {
        ApiKey revokedApiKey = new ApiKey(this);
        Date now = new Date();
        revokedApiKey.setRevoked(true);
        revokedApiKey.setUpdatedAt(now);
        revokedApiKey.setRevokedAt(now);
        return revokedApiKey;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public String getSubscription() {
        return this.subscription;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public String getPlan() {
        return this.plan;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public void setPlan(String plan) {
        this.plan = plan;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public String getApi() {
        return this.api;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public void setApi(String api) {
        this.api = api;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiKey apiKey = (ApiKey)o;
        return Objects.equals(this.id, apiKey.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Generated
    public static ApiKeyBuilder builder() {
        return new ApiKeyBuilder();
    }

    @Generated
    public ApiKeyBuilder toBuilder() {
        return new ApiKeyBuilder().id(this.id).key(this.key).subscriptions(this.subscriptions).environmentId(this.environmentId).subscription(this.subscription).plan(this.plan).api(this.api).application(this.application).expireAt(this.expireAt).createdAt(this.createdAt).updatedAt(this.updatedAt).revoked(this.revoked).paused(this.paused).revokedAt(this.revokedAt).federated(this.federated).daysToExpirationOnLastNotification(this.daysToExpirationOnLastNotification);
    }

    @Generated
    public ApiKey() {
    }

    @Generated
    public ApiKey(String id, String key, List<String> subscriptions, String environmentId, String subscription, String plan, String api, String application, Date expireAt, Date createdAt, Date updatedAt, boolean revoked, boolean paused, Date revokedAt, boolean federated, Integer daysToExpirationOnLastNotification) {
        this.id = id;
        this.key = key;
        this.subscriptions = subscriptions;
        this.environmentId = environmentId;
        this.subscription = subscription;
        this.plan = plan;
        this.api = api;
        this.application = application;
        this.expireAt = expireAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.revoked = revoked;
        this.paused = paused;
        this.revokedAt = revokedAt;
        this.federated = federated;
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
    }

    @Generated
    public String toString() {
        return "ApiKey(id=" + this.getId() + ", key=" + this.getKey() + ", subscriptions=" + String.valueOf(this.getSubscriptions()) + ", environmentId=" + this.getEnvironmentId() + ", subscription=" + this.getSubscription() + ", plan=" + this.getPlan() + ", api=" + this.getApi() + ", application=" + this.getApplication() + ", expireAt=" + String.valueOf(this.getExpireAt()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", revoked=" + this.isRevoked() + ", paused=" + this.isPaused() + ", revokedAt=" + String.valueOf(this.getRevokedAt()) + ", federated=" + this.isFederated() + ", daysToExpirationOnLastNotification=" + this.getDaysToExpirationOnLastNotification() + ")";
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public void setSubscriptions(List<String> subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Generated
    public List<String> getSubscriptions() {
        return this.subscriptions;
    }

    @Generated
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Generated
    public void setApplication(String application) {
        this.application = application;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public void setExpireAt(Date expireAt) {
        this.expireAt = expireAt;
    }

    @Generated
    public Date getExpireAt() {
        return this.expireAt;
    }

    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public void setRevoked(boolean revoked) {
        this.revoked = revoked;
    }

    @Generated
    public boolean isRevoked() {
        return this.revoked;
    }

    @Generated
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Generated
    public boolean isPaused() {
        return this.paused;
    }

    @Generated
    public void setRevokedAt(Date revokedAt) {
        this.revokedAt = revokedAt;
    }

    @Generated
    public Date getRevokedAt() {
        return this.revokedAt;
    }

    @Generated
    public boolean isFederated() {
        return this.federated;
    }

    @Generated
    public void setFederated(boolean federated) {
        this.federated = federated;
    }

    @Generated
    public void setDaysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
    }

    @Generated
    public Integer getDaysToExpirationOnLastNotification() {
        return this.daysToExpirationOnLastNotification;
    }

    @Generated
    public static class ApiKeyBuilder {
        @Generated
        private String id;
        @Generated
        private String key;
        @Generated
        private List<String> subscriptions;
        @Generated
        private String environmentId;
        @Generated
        private String subscription;
        @Generated
        private String plan;
        @Generated
        private String api;
        @Generated
        private String application;
        @Generated
        private Date expireAt;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private boolean revoked;
        @Generated
        private boolean paused;
        @Generated
        private Date revokedAt;
        @Generated
        private boolean federated;
        @Generated
        private Integer daysToExpirationOnLastNotification;

        @Generated
        ApiKeyBuilder() {
        }

        @Generated
        public ApiKeyBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ApiKeyBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public ApiKeyBuilder subscriptions(List<String> subscriptions) {
            this.subscriptions = subscriptions;
            return this;
        }

        @Generated
        public ApiKeyBuilder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Deprecated
        @Generated
        public ApiKeyBuilder subscription(String subscription) {
            this.subscription = subscription;
            return this;
        }

        @Deprecated
        @Generated
        public ApiKeyBuilder plan(String plan) {
            this.plan = plan;
            return this;
        }

        @Deprecated
        @Generated
        public ApiKeyBuilder api(String api) {
            this.api = api;
            return this;
        }

        @Generated
        public ApiKeyBuilder application(String application) {
            this.application = application;
            return this;
        }

        @Generated
        public ApiKeyBuilder expireAt(Date expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Generated
        public ApiKeyBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public ApiKeyBuilder updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public ApiKeyBuilder revoked(boolean revoked) {
            this.revoked = revoked;
            return this;
        }

        @Generated
        public ApiKeyBuilder paused(boolean paused) {
            this.paused = paused;
            return this;
        }

        @Generated
        public ApiKeyBuilder revokedAt(Date revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        @Generated
        public ApiKeyBuilder federated(boolean federated) {
            this.federated = federated;
            return this;
        }

        @Generated
        public ApiKeyBuilder daysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
            this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
            return this;
        }

        @Generated
        public ApiKey build() {
            return new ApiKey(this.id, this.key, this.subscriptions, this.environmentId, this.subscription, this.plan, this.api, this.application, this.expireAt, this.createdAt, this.updatedAt, this.revoked, this.paused, this.revokedAt, this.federated, this.daysToExpirationOnLastNotification);
        }

        @Generated
        public String toString() {
            return "ApiKey.ApiKeyBuilder(id=" + this.id + ", key=" + this.key + ", subscriptions=" + String.valueOf(this.subscriptions) + ", environmentId=" + this.environmentId + ", subscription=" + this.subscription + ", plan=" + this.plan + ", api=" + this.api + ", application=" + this.application + ", expireAt=" + String.valueOf(this.expireAt) + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", revoked=" + this.revoked + ", paused=" + this.paused + ", revokedAt=" + String.valueOf(this.revokedAt) + ", federated=" + this.federated + ", daysToExpirationOnLastNotification=" + this.daysToExpirationOnLastNotification + ")";
        }
    }

    public static enum AuditEvent implements Audit.ApiAuditEvent
    {
        APIKEY_CREATED,
        APIKEY_RENEWED,
        APIKEY_REVOKED,
        APIKEY_EXPIRED,
        APIKEY_REACTIVATED;

    }
}

