/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.CrudRepository;
import io.gravitee.repository.management.api.search.EventCriteria;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public interface EventRepository
extends CrudRepository<Event, String> {
    public Page<Event> search(EventCriteria var1, Pageable var2);

    public List<Event> search(EventCriteria var1);

    public Event createOrPatch(Event var1) throws TechnicalException;

    public long deleteApiEvents(String var1) throws TechnicalException;

    public List<Event> findByEnvironmentId(String var1);

    public List<Event> findByOrganizationId(String var1);

    public Stream<EventToClean> findEventsToClean(String var1);

    @Override
    public void delete(Collection<String> var1);

    public static final class EventGroupKeyHelper {
        private EventGroupKeyHelper() {
        }

        public static EventToCleanGroup determineGroup(EventType eventType, Map<String, String> properties) {
            if (eventType == null || properties == null) {
                return null;
            }
            String referenceId = switch (eventType) {
                case EventType.PUBLISH_API, EventType.PUBLISH_API_RESULT, EventType.UNPUBLISH_API, EventType.UNPUBLISH_API_RESULT, EventType.START_API, EventType.STOP_API, EventType.DEBUG_API -> properties.get(Event.EventProperties.API_ID.getValue());
                case EventType.PUBLISH_DICTIONARY, EventType.UNPUBLISH_DICTIONARY, EventType.START_DICTIONARY, EventType.STOP_DICTIONARY -> properties.get(Event.EventProperties.DICTIONARY_ID.getValue());
                case EventType.PUBLISH_ORGANIZATION, EventType.PUBLISH_ORGANIZATION_LICENSE -> properties.get(Event.EventProperties.ORGANIZATION_ID.getValue());
                case EventType.DEPLOY_SHARED_POLICY_GROUP, EventType.UNDEPLOY_SHARED_POLICY_GROUP -> properties.get(Event.EventProperties.SHARED_POLICY_GROUP_ID.getValue());
                case EventType.GATEWAY_STARTED, EventType.GATEWAY_STOPPED -> properties.get(Event.EventProperties.ID.getValue());
                default -> properties.get(Event.EventProperties.ID.getValue());
            };
            return referenceId != null && !referenceId.isBlank() ? new EventToCleanGroup(eventType.name(), referenceId) : null;
        }
    }

    public record EventToCleanGroup(String type, String referenceId) {
    }

    public record EventToClean(String id, EventToCleanGroup group) {
    }
}

