/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.model;

import io.gravitee.definition.model.Origin;
import io.gravitee.repository.management.model.ApiKeyMode;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.ApplicationType;
import io.gravitee.repository.management.model.Audit;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class Application {
    public static final String METADATA_CLIENT_ID = "client_id";
    public static final String METADATA_TYPE = "type";
    public static final String METADATA_REGISTRATION_PAYLOAD = "registration_payload";
    public static final String METADATA_CLIENT_CERTIFICATE = "client_certificate";
    public static final String METADATA_ADDITIONAL_CLIENT_METADATA = "additional_client_metadata";
    private String id;
    private String environmentId;
    private String name;
    private String description;
    private String picture;
    private String domain;
    private Date createdAt;
    private Date updatedAt;
    private Set<String> groups = new HashSet<String>();
    private ApplicationStatus status;
    private ApplicationType type;
    private Map<String, String> metadata;
    private boolean disableMembershipNotifications;
    private String background;
    private ApiKeyMode apiKeyMode = ApiKeyMode.UNSPECIFIED;
    private Origin origin;

    public Application(Application cloned) {
        this.id = cloned.id;
        this.environmentId = cloned.environmentId;
        this.name = cloned.name;
        this.description = cloned.description;
        this.createdAt = cloned.createdAt;
        this.updatedAt = cloned.updatedAt;
        if (!CollectionUtils.isEmpty(cloned.groups)) {
            this.groups.addAll(cloned.groups);
        }
        this.status = cloned.status;
        this.disableMembershipNotifications = cloned.disableMembershipNotifications;
        this.background = cloned.background;
        this.domain = cloned.domain;
        this.apiKeyMode = cloned.apiKeyMode;
        this.picture = cloned.picture;
        this.type = cloned.type;
        this.origin = cloned.origin;
        this.metadata = cloned.metadata != null ? new HashMap<String, String>(cloned.metadata) : null;
    }

    public boolean addGroup(String group) {
        if (this.groups == null) {
            this.groups = new HashSet<String>();
        }
        return this.groups.add(group);
    }

    public boolean addAllGroups(Collection<String> groupsToAdd) {
        if (this.groups == null) {
            this.groups = new HashSet<String>();
        }
        return this.groups.addAll(groupsToAdd);
    }

    public Set<String> getGroups() {
        return this.groups != null ? new HashSet<String>(this.groups) : new HashSet();
    }

    public void setGroups(Collection<String> groups) {
        this.groups = groups != null ? new HashSet<String>(groups) : null;
    }

    public void removeGroup(String group) {
        if (this.groups != null) {
            this.groups.remove(group);
        }
    }

    @Generated
    public static ApplicationBuilder builder() {
        return new ApplicationBuilder();
    }

    @Generated
    public ApplicationBuilder toBuilder() {
        return new ApplicationBuilder().id(this.id).environmentId(this.environmentId).name(this.name).description(this.description).picture(this.picture).domain(this.domain).createdAt(this.createdAt).updatedAt(this.updatedAt).groups(this.groups).status(this.status).type(this.type).metadata(this.metadata).disableMembershipNotifications(this.disableMembershipNotifications).background(this.background).apiKeyMode(this.apiKeyMode).origin(this.origin);
    }

    @Generated
    public Application() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getPicture() {
        return this.picture;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public ApplicationStatus getStatus() {
        return this.status;
    }

    @Generated
    public ApplicationType getType() {
        return this.type;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    @Generated
    public String getBackground() {
        return this.background;
    }

    @Generated
    public ApiKeyMode getApiKeyMode() {
        return this.apiKeyMode;
    }

    @Generated
    public Origin getOrigin() {
        return this.origin;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setPicture(String picture) {
        this.picture = picture;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setStatus(ApplicationStatus status) {
        this.status = status;
    }

    @Generated
    public void setType(ApplicationType type) {
        this.type = type;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    @Generated
    public void setBackground(String background) {
        this.background = background;
    }

    @Generated
    public void setApiKeyMode(ApiKeyMode apiKeyMode) {
        this.apiKeyMode = apiKeyMode;
    }

    @Generated
    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    @Generated
    public String toString() {
        return "Application(id=" + this.getId() + ", environmentId=" + this.getEnvironmentId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", picture=" + this.getPicture() + ", domain=" + this.getDomain() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", groups=" + String.valueOf(this.getGroups()) + ", status=" + String.valueOf((Object)this.getStatus()) + ", type=" + String.valueOf((Object)this.getType()) + ", metadata=" + String.valueOf(this.getMetadata()) + ", disableMembershipNotifications=" + this.isDisableMembershipNotifications() + ", background=" + this.getBackground() + ", apiKeyMode=" + String.valueOf((Object)this.getApiKeyMode()) + ", origin=" + String.valueOf(this.getOrigin()) + ")";
    }

    @Generated
    public Application(String id, String environmentId, String name, String description, String picture, String domain, Date createdAt, Date updatedAt, Set<String> groups, ApplicationStatus status, ApplicationType type, Map<String, String> metadata, boolean disableMembershipNotifications, String background, ApiKeyMode apiKeyMode, Origin origin) {
        this.id = id;
        this.environmentId = environmentId;
        this.name = name;
        this.description = description;
        this.picture = picture;
        this.domain = domain;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.groups = groups;
        this.status = status;
        this.type = type;
        this.metadata = metadata;
        this.disableMembershipNotifications = disableMembershipNotifications;
        this.background = background;
        this.apiKeyMode = apiKeyMode;
        this.origin = origin;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        Application other = (Application)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Application;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public static class ApplicationBuilder {
        @Generated
        private String id;
        @Generated
        private String environmentId;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String picture;
        @Generated
        private String domain;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private Set<String> groups;
        @Generated
        private ApplicationStatus status;
        @Generated
        private ApplicationType type;
        @Generated
        private Map<String, String> metadata;
        @Generated
        private boolean disableMembershipNotifications;
        @Generated
        private String background;
        @Generated
        private ApiKeyMode apiKeyMode;
        @Generated
        private Origin origin;

        @Generated
        ApplicationBuilder() {
        }

        @Generated
        public ApplicationBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ApplicationBuilder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Generated
        public ApplicationBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ApplicationBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public ApplicationBuilder picture(String picture) {
            this.picture = picture;
            return this;
        }

        @Generated
        public ApplicationBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public ApplicationBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public ApplicationBuilder updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public ApplicationBuilder groups(Set<String> groups) {
            this.groups = groups;
            return this;
        }

        @Generated
        public ApplicationBuilder status(ApplicationStatus status) {
            this.status = status;
            return this;
        }

        @Generated
        public ApplicationBuilder type(ApplicationType type) {
            this.type = type;
            return this;
        }

        @Generated
        public ApplicationBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public ApplicationBuilder disableMembershipNotifications(boolean disableMembershipNotifications) {
            this.disableMembershipNotifications = disableMembershipNotifications;
            return this;
        }

        @Generated
        public ApplicationBuilder background(String background) {
            this.background = background;
            return this;
        }

        @Generated
        public ApplicationBuilder apiKeyMode(ApiKeyMode apiKeyMode) {
            this.apiKeyMode = apiKeyMode;
            return this;
        }

        @Generated
        public ApplicationBuilder origin(Origin origin) {
            this.origin = origin;
            return this;
        }

        @Generated
        public Application build() {
            return new Application(this.id, this.environmentId, this.name, this.description, this.picture, this.domain, this.createdAt, this.updatedAt, this.groups, this.status, this.type, this.metadata, this.disableMembershipNotifications, this.background, this.apiKeyMode, this.origin);
        }

        @Generated
        public String toString() {
            return "Application.ApplicationBuilder(id=" + this.id + ", environmentId=" + this.environmentId + ", name=" + this.name + ", description=" + this.description + ", picture=" + this.picture + ", domain=" + this.domain + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", groups=" + String.valueOf(this.groups) + ", status=" + String.valueOf((Object)this.status) + ", type=" + String.valueOf((Object)this.type) + ", metadata=" + String.valueOf(this.metadata) + ", disableMembershipNotifications=" + this.disableMembershipNotifications + ", background=" + this.background + ", apiKeyMode=" + String.valueOf((Object)this.apiKeyMode) + ", origin=" + String.valueOf(this.origin) + ")";
        }
    }

    public static enum AuditEvent implements Audit.AuditEvent
    {
        APPLICATION_CREATED,
        APPLICATION_UPDATED,
        APPLICATION_ARCHIVED,
        APPLICATION_RESTORED;

    }
}

