/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api;

import io.gravitee.common.data.domain.Page;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.CrudRepository;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.AsyncJob;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AsyncJobRepository
extends CrudRepository<AsyncJob, String> {
    public static final Logger LOGGER = LoggerFactory.getLogger(AsyncJobRepository.class);

    public Optional<AsyncJob> findPendingJobFor(String var1) throws TechnicalException;

    public Page<AsyncJob> search(SearchCriteria var1, Pageable var2) throws TechnicalException;

    public void delay(String var1, Date var2) throws TechnicalException;

    default public Page<AsyncJob> search(SearchCriteria criteria) throws TechnicalException {
        return this.search(criteria, new PageableBuilder().pageSize(10).pageNumber(0).build());
    }

    public List<String> deleteByEnvironmentId(String var1) throws TechnicalException;

    default public AsyncJob handleDeadLine(AsyncJob job) {
        if (job.isLate()) {
            job.setUpdatedAt(Date.from(TimeProvider.instantNow()));
            job.setStatus("TIMEOUT");
            try {
                return this.update(job);
            }
            catch (TechnicalException e) {
                LOGGER.error("An error occurs while updating job {} to timeout", (Object)job.getId(), (Object)e);
                return job;
            }
        }
        return job;
    }

    public record SearchCriteria(String environmentId, Optional<String> initiatorId, Optional<String> type, Optional<String> status, Optional<String> sourceId) {
    }
}

