/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api.search;

import io.gravitee.repository.management.model.Audit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuditCriteria {
    private Map<Audit.AuditReferenceType, List<String>> references;
    private Map<String, String> properties;
    private List<String> events;
    private long from;
    private long to;
    private List<String> environmentIds;
    private String organizationId;

    AuditCriteria(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.references = new HashMap<Audit.AuditReferenceType, List<String>>(builder.references);
        this.properties = new HashMap<String, String>(builder.properties);
        if (builder.events != null) {
            this.events = builder.events;
        }
        this.environmentIds = builder.environmentIds;
        this.organizationId = builder.organizationId;
    }

    public Map<Audit.AuditReferenceType, List<String>> getReferences() {
        return this.references;
    }

    public void setReferences(Map<Audit.AuditReferenceType, List<String>> references) {
        this.references = references;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public long getFrom() {
        return this.from;
    }

    public void setFrom(long from) {
        this.from = from;
    }

    public long getTo() {
        return this.to;
    }

    public void setTo(long to) {
        this.to = to;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public void setEvents(List<String> events) {
        this.events = events;
    }

    public List<String> getEnvironmentIds() {
        return this.environmentIds;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditCriteria that = (AuditCriteria)o;
        if (this.from != that.from) {
            return false;
        }
        if (this.to != that.to) {
            return false;
        }
        if (this.references != null ? !this.references.equals(that.references) : that.references != null) {
            return false;
        }
        if (this.environmentIds != null ? !this.environmentIds.equals(that.environmentIds) : that.environmentIds != null) {
            return false;
        }
        if (this.organizationId != that.organizationId) {
            return false;
        }
        return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
    }

    public int hashCode() {
        int result = this.references != null ? this.references.hashCode() : 0;
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + (int)(this.from ^ this.from >>> 32);
        result = 31 * result + (int)(this.to ^ this.to >>> 32);
        return result;
    }

    public static class Builder {
        private Map<String, String> properties = new HashMap<String, String>();
        private Map<Audit.AuditReferenceType, List<String>> references = new HashMap<Audit.AuditReferenceType, List<String>>();
        private long from;
        private long to;
        private List<String> events;
        private List<String> environmentIds;
        private String organizationId;

        public Builder from(long from) {
            this.from = from;
            return this;
        }

        public Builder to(long to) {
            this.to = to;
            return this;
        }

        public Builder references(Audit.AuditReferenceType referenceType, List<String> referenceIds) {
            this.references.put(referenceType, referenceIds);
            return this;
        }

        public Builder property(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder events(List<String> events) {
            this.events = events;
            return this;
        }

        public AuditCriteria build() {
            return new AuditCriteria(this);
        }

        public Builder environmentIds(List<String> environmentIds) {
            this.environmentIds = environmentIds;
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }
    }
}

