/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.model;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.repository.management.model.Audit;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public class Plan {
    private String id;
    private DefinitionVersion definitionVersion;
    private String crossId;
    private String name;
    private String description;
    private PlanSecurityType security;
    private String securityDefinition;
    private String selectionRule;
    private PlanValidationType validation;
    private PlanType type;
    private PlanMode mode;
    private Status status;
    private int order;
    private String api;
    private String environmentId;
    private Date createdAt;
    private Date updatedAt;
    private Date publishedAt;
    private Date closedAt;
    private String definition;
    private List<String> characteristics;
    private List<String> excludedGroups;
    private Date needRedeployAt;
    private boolean commentRequired;
    private String commentMessage;
    private String generalConditions;
    private Set<String> tags;
    private ApiType apiType;

    public Plan(Plan cloned) {
        this.id = cloned.id;
        this.definitionVersion = cloned.definitionVersion;
        this.crossId = cloned.crossId;
        this.name = cloned.name;
        this.description = cloned.description;
        this.security = cloned.security;
        this.validation = cloned.validation;
        this.type = cloned.type;
        this.mode = cloned.mode;
        this.status = cloned.status;
        this.order = cloned.order;
        this.api = cloned.api;
        this.environmentId = cloned.environmentId;
        this.createdAt = cloned.createdAt;
        this.updatedAt = cloned.updatedAt;
        this.publishedAt = cloned.publishedAt;
        this.closedAt = cloned.closedAt;
        this.definition = cloned.definition;
        this.characteristics = cloned.characteristics;
        this.excludedGroups = cloned.excludedGroups;
        this.needRedeployAt = cloned.needRedeployAt;
        this.selectionRule = cloned.selectionRule;
        this.tags = cloned.tags;
        this.generalConditions = cloned.generalConditions;
        this.commentMessage = cloned.commentMessage;
        this.commentRequired = cloned.commentRequired;
        this.securityDefinition = cloned.securityDefinition;
        this.apiType = cloned.apiType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plan plan = (Plan)o;
        return Objects.equals(this.id, plan.id);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "Plan{id='" + this.id + "', definitionVersion='" + this.definitionVersion + "', crossId='" + this.crossId + "', api='" + this.api + "', environmentId='" + this.environmentId + "', name='" + this.name + "', description='" + this.description + "', validation=" + this.validation + ", excludedGroups=" + this.excludedGroups + ", type=" + this.type + "}";
    }

    @Generated
    private static Set<String> $default$tags() {
        return new HashSet<String>();
    }

    @Generated
    public static PlanBuilder builder() {
        return new PlanBuilder();
    }

    @Generated
    public PlanBuilder toBuilder() {
        return new PlanBuilder().id(this.id).definitionVersion(this.definitionVersion).crossId(this.crossId).name(this.name).description(this.description).security(this.security).securityDefinition(this.securityDefinition).selectionRule(this.selectionRule).validation(this.validation).type(this.type).mode(this.mode).status(this.status).order(this.order).api(this.api).environmentId(this.environmentId).createdAt(this.createdAt).updatedAt(this.updatedAt).publishedAt(this.publishedAt).closedAt(this.closedAt).definition(this.definition).characteristics(this.characteristics).excludedGroups(this.excludedGroups).needRedeployAt(this.needRedeployAt).commentRequired(this.commentRequired).commentMessage(this.commentMessage).generalConditions(this.generalConditions).tags(this.tags).apiType(this.apiType);
    }

    @Generated
    public Plan(String id, DefinitionVersion definitionVersion, String crossId, String name, String description, PlanSecurityType security, String securityDefinition, String selectionRule, PlanValidationType validation, PlanType type, PlanMode mode, Status status, int order, String api, String environmentId, Date createdAt, Date updatedAt, Date publishedAt, Date closedAt, String definition, List<String> characteristics, List<String> excludedGroups, Date needRedeployAt, boolean commentRequired, String commentMessage, String generalConditions, Set<String> tags, ApiType apiType) {
        this.id = id;
        this.definitionVersion = definitionVersion;
        this.crossId = crossId;
        this.name = name;
        this.description = description;
        this.security = security;
        this.securityDefinition = securityDefinition;
        this.selectionRule = selectionRule;
        this.validation = validation;
        this.type = type;
        this.mode = mode;
        this.status = status;
        this.order = order;
        this.api = api;
        this.environmentId = environmentId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.publishedAt = publishedAt;
        this.closedAt = closedAt;
        this.definition = definition;
        this.characteristics = characteristics;
        this.excludedGroups = excludedGroups;
        this.needRedeployAt = needRedeployAt;
        this.commentRequired = commentRequired;
        this.commentMessage = commentMessage;
        this.generalConditions = generalConditions;
        this.tags = tags;
        this.apiType = apiType;
    }

    @Generated
    public Plan() {
        this.tags = Plan.$default$tags();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public DefinitionVersion getDefinitionVersion() {
        return this.definitionVersion;
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public PlanSecurityType getSecurity() {
        return this.security;
    }

    @Generated
    public String getSecurityDefinition() {
        return this.securityDefinition;
    }

    @Generated
    public String getSelectionRule() {
        return this.selectionRule;
    }

    @Generated
    public PlanValidationType getValidation() {
        return this.validation;
    }

    @Generated
    public PlanType getType() {
        return this.type;
    }

    @Generated
    public PlanMode getMode() {
        return this.mode;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public String getApi() {
        return this.api;
    }

    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public Date getPublishedAt() {
        return this.publishedAt;
    }

    @Generated
    public Date getClosedAt() {
        return this.closedAt;
    }

    @Generated
    public String getDefinition() {
        return this.definition;
    }

    @Generated
    public List<String> getCharacteristics() {
        return this.characteristics;
    }

    @Generated
    public List<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    @Generated
    public Date getNeedRedeployAt() {
        return this.needRedeployAt;
    }

    @Generated
    public boolean isCommentRequired() {
        return this.commentRequired;
    }

    @Generated
    public String getCommentMessage() {
        return this.commentMessage;
    }

    @Generated
    public String getGeneralConditions() {
        return this.generalConditions;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public ApiType getApiType() {
        return this.apiType;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setDefinitionVersion(DefinitionVersion definitionVersion) {
        this.definitionVersion = definitionVersion;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setSecurity(PlanSecurityType security) {
        this.security = security;
    }

    @Generated
    public void setSecurityDefinition(String securityDefinition) {
        this.securityDefinition = securityDefinition;
    }

    @Generated
    public void setSelectionRule(String selectionRule) {
        this.selectionRule = selectionRule;
    }

    @Generated
    public void setValidation(PlanValidationType validation) {
        this.validation = validation;
    }

    @Generated
    public void setType(PlanType type) {
        this.type = type;
    }

    @Generated
    public void setMode(PlanMode mode) {
        this.mode = mode;
    }

    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setApi(String api) {
        this.api = api;
    }

    @Generated
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setPublishedAt(Date publishedAt) {
        this.publishedAt = publishedAt;
    }

    @Generated
    public void setClosedAt(Date closedAt) {
        this.closedAt = closedAt;
    }

    @Generated
    public void setDefinition(String definition) {
        this.definition = definition;
    }

    @Generated
    public void setCharacteristics(List<String> characteristics) {
        this.characteristics = characteristics;
    }

    @Generated
    public void setExcludedGroups(List<String> excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    @Generated
    public void setNeedRedeployAt(Date needRedeployAt) {
        this.needRedeployAt = needRedeployAt;
    }

    @Generated
    public void setCommentRequired(boolean commentRequired) {
        this.commentRequired = commentRequired;
    }

    @Generated
    public void setCommentMessage(String commentMessage) {
        this.commentMessage = commentMessage;
    }

    @Generated
    public void setGeneralConditions(String generalConditions) {
        this.generalConditions = generalConditions;
    }

    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setApiType(ApiType apiType) {
        this.apiType = apiType;
    }

    public static enum PlanSecurityType {
        KEY_LESS,
        API_KEY,
        OAUTH2,
        JWT,
        MTLS;

    }

    public static enum PlanValidationType {
        AUTO,
        MANUAL;

    }

    public static enum PlanType {
        API,
        CATALOG;

    }

    public static enum PlanMode {
        STANDARD,
        PUSH;

    }

    public static enum Status {
        STAGING,
        PUBLISHED,
        CLOSED,
        DEPRECATED;

    }

    @Generated
    public static class PlanBuilder {
        @Generated
        private String id;
        @Generated
        private DefinitionVersion definitionVersion;
        @Generated
        private String crossId;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private PlanSecurityType security;
        @Generated
        private String securityDefinition;
        @Generated
        private String selectionRule;
        @Generated
        private PlanValidationType validation;
        @Generated
        private PlanType type;
        @Generated
        private PlanMode mode;
        @Generated
        private Status status;
        @Generated
        private int order;
        @Generated
        private String api;
        @Generated
        private String environmentId;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private Date publishedAt;
        @Generated
        private Date closedAt;
        @Generated
        private String definition;
        @Generated
        private List<String> characteristics;
        @Generated
        private List<String> excludedGroups;
        @Generated
        private Date needRedeployAt;
        @Generated
        private boolean commentRequired;
        @Generated
        private String commentMessage;
        @Generated
        private String generalConditions;
        @Generated
        private boolean tags$set;
        @Generated
        private Set<String> tags$value;
        @Generated
        private ApiType apiType;

        @Generated
        PlanBuilder() {
        }

        @Generated
        public PlanBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public PlanBuilder definitionVersion(DefinitionVersion definitionVersion) {
            this.definitionVersion = definitionVersion;
            return this;
        }

        @Generated
        public PlanBuilder crossId(String crossId) {
            this.crossId = crossId;
            return this;
        }

        @Generated
        public PlanBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public PlanBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public PlanBuilder security(PlanSecurityType security) {
            this.security = security;
            return this;
        }

        @Generated
        public PlanBuilder securityDefinition(String securityDefinition) {
            this.securityDefinition = securityDefinition;
            return this;
        }

        @Generated
        public PlanBuilder selectionRule(String selectionRule) {
            this.selectionRule = selectionRule;
            return this;
        }

        @Generated
        public PlanBuilder validation(PlanValidationType validation) {
            this.validation = validation;
            return this;
        }

        @Generated
        public PlanBuilder type(PlanType type) {
            this.type = type;
            return this;
        }

        @Generated
        public PlanBuilder mode(PlanMode mode) {
            this.mode = mode;
            return this;
        }

        @Generated
        public PlanBuilder status(Status status) {
            this.status = status;
            return this;
        }

        @Generated
        public PlanBuilder order(int order) {
            this.order = order;
            return this;
        }

        @Generated
        public PlanBuilder api(String api) {
            this.api = api;
            return this;
        }

        @Generated
        public PlanBuilder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Generated
        public PlanBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public PlanBuilder updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public PlanBuilder publishedAt(Date publishedAt) {
            this.publishedAt = publishedAt;
            return this;
        }

        @Generated
        public PlanBuilder closedAt(Date closedAt) {
            this.closedAt = closedAt;
            return this;
        }

        @Generated
        public PlanBuilder definition(String definition) {
            this.definition = definition;
            return this;
        }

        @Generated
        public PlanBuilder characteristics(List<String> characteristics) {
            this.characteristics = characteristics;
            return this;
        }

        @Generated
        public PlanBuilder excludedGroups(List<String> excludedGroups) {
            this.excludedGroups = excludedGroups;
            return this;
        }

        @Generated
        public PlanBuilder needRedeployAt(Date needRedeployAt) {
            this.needRedeployAt = needRedeployAt;
            return this;
        }

        @Generated
        public PlanBuilder commentRequired(boolean commentRequired) {
            this.commentRequired = commentRequired;
            return this;
        }

        @Generated
        public PlanBuilder commentMessage(String commentMessage) {
            this.commentMessage = commentMessage;
            return this;
        }

        @Generated
        public PlanBuilder generalConditions(String generalConditions) {
            this.generalConditions = generalConditions;
            return this;
        }

        @Generated
        public PlanBuilder tags(Set<String> tags) {
            this.tags$value = tags;
            this.tags$set = true;
            return this;
        }

        @Generated
        public PlanBuilder apiType(ApiType apiType) {
            this.apiType = apiType;
            return this;
        }

        @Generated
        public Plan build() {
            Set<String> tags$value = this.tags$value;
            if (!this.tags$set) {
                tags$value = Plan.$default$tags();
            }
            return new Plan(this.id, this.definitionVersion, this.crossId, this.name, this.description, this.security, this.securityDefinition, this.selectionRule, this.validation, this.type, this.mode, this.status, this.order, this.api, this.environmentId, this.createdAt, this.updatedAt, this.publishedAt, this.closedAt, this.definition, this.characteristics, this.excludedGroups, this.needRedeployAt, this.commentRequired, this.commentMessage, this.generalConditions, tags$value, this.apiType);
        }

        @Generated
        public String toString() {
            return "Plan.PlanBuilder(id=" + this.id + ", definitionVersion=" + this.definitionVersion + ", crossId=" + this.crossId + ", name=" + this.name + ", description=" + this.description + ", security=" + this.security + ", securityDefinition=" + this.securityDefinition + ", selectionRule=" + this.selectionRule + ", validation=" + this.validation + ", type=" + this.type + ", mode=" + this.mode + ", status=" + this.status + ", order=" + this.order + ", api=" + this.api + ", environmentId=" + this.environmentId + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", publishedAt=" + this.publishedAt + ", closedAt=" + this.closedAt + ", definition=" + this.definition + ", characteristics=" + this.characteristics + ", excludedGroups=" + this.excludedGroups + ", needRedeployAt=" + this.needRedeployAt + ", commentRequired=" + this.commentRequired + ", commentMessage=" + this.commentMessage + ", generalConditions=" + this.generalConditions + ", tags$value=" + this.tags$value + ", apiType=" + this.apiType + ")";
        }
    }

    public static enum AuditEvent implements Audit.ApiAuditEvent
    {
        PLAN_CREATED,
        PLAN_UPDATED,
        PLAN_DELETED,
        PLAN_PUBLISHED,
        PLAN_CLOSED,
        PLAN_DEPRECATED;

    }
}

