/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.model;

import io.gravitee.repository.management.model.Audit;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import lombok.Generated;

public class Subscription
implements Serializable {
    private String id;
    private String api;
    private String environmentId;
    private String plan;
    private String application;
    private String clientId;
    private String clientCertificate;
    private Date processedAt;
    private String request;
    private String reason;
    private Status status;
    private ConsumerStatus consumerStatus = ConsumerStatus.STARTED;
    private String processedBy;
    private String subscribedBy;
    private Date startingAt;
    private Date endingAt;
    private Date createdAt;
    private Date updatedAt;
    private Date closedAt;
    private Date pausedAt;
    private Date consumerPausedAt;
    private Integer generalConditionsContentRevision;
    private String generalConditionsContentPageId;
    private Boolean generalConditionsAccepted;
    private Integer daysToExpirationOnLastNotification;
    private String configuration;
    private Map<String, String> metadata;
    private Type type = Type.STANDARD;
    private String failureCause;

    public Subscription(Subscription cloned) {
        this.id = cloned.id;
        this.api = cloned.api;
        this.environmentId = cloned.environmentId;
        this.plan = cloned.plan;
        this.application = cloned.application;
        this.clientId = cloned.clientId;
        this.clientCertificate = cloned.clientCertificate;
        this.processedAt = cloned.processedAt;
        this.request = cloned.request;
        this.reason = cloned.reason;
        this.status = cloned.status;
        this.consumerStatus = cloned.consumerStatus;
        this.processedBy = cloned.processedBy;
        this.subscribedBy = cloned.subscribedBy;
        this.startingAt = cloned.startingAt;
        this.endingAt = cloned.endingAt;
        this.createdAt = cloned.createdAt;
        this.updatedAt = cloned.updatedAt;
        this.closedAt = cloned.closedAt;
        this.pausedAt = cloned.pausedAt;
        this.consumerPausedAt = cloned.consumerPausedAt;
        this.generalConditionsAccepted = cloned.generalConditionsAccepted;
        this.generalConditionsContentRevision = cloned.generalConditionsContentRevision;
        this.generalConditionsContentPageId = cloned.generalConditionsContentPageId;
        this.daysToExpirationOnLastNotification = cloned.daysToExpirationOnLastNotification;
        this.configuration = cloned.configuration;
        this.metadata = cloned.metadata;
        this.type = cloned.type;
        this.failureCause = cloned.failureCause;
    }

    public boolean canBeStartedByConsumer() {
        return ConsumerStatus.STOPPED.equals((Object)this.consumerStatus) || ConsumerStatus.FAILURE.equals((Object)this.consumerStatus);
    }

    public boolean canBeStoppedByConsumer() {
        return ConsumerStatus.STARTED.equals((Object)this.consumerStatus) || ConsumerStatus.FAILURE.equals((Object)this.consumerStatus);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription that = (Subscription)o;
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    @Generated
    public static SubscriptionBuilder builder() {
        return new SubscriptionBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getApi() {
        return this.api;
    }

    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Generated
    public String getPlan() {
        return this.plan;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientCertificate() {
        return this.clientCertificate;
    }

    @Generated
    public Date getProcessedAt() {
        return this.processedAt;
    }

    @Generated
    public String getRequest() {
        return this.request;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public ConsumerStatus getConsumerStatus() {
        return this.consumerStatus;
    }

    @Generated
    public String getProcessedBy() {
        return this.processedBy;
    }

    @Generated
    public String getSubscribedBy() {
        return this.subscribedBy;
    }

    @Generated
    public Date getStartingAt() {
        return this.startingAt;
    }

    @Generated
    public Date getEndingAt() {
        return this.endingAt;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public Date getClosedAt() {
        return this.closedAt;
    }

    @Generated
    public Date getPausedAt() {
        return this.pausedAt;
    }

    @Generated
    public Date getConsumerPausedAt() {
        return this.consumerPausedAt;
    }

    @Generated
    public Integer getGeneralConditionsContentRevision() {
        return this.generalConditionsContentRevision;
    }

    @Generated
    public String getGeneralConditionsContentPageId() {
        return this.generalConditionsContentPageId;
    }

    @Generated
    public Boolean getGeneralConditionsAccepted() {
        return this.generalConditionsAccepted;
    }

    @Generated
    public Integer getDaysToExpirationOnLastNotification() {
        return this.daysToExpirationOnLastNotification;
    }

    @Generated
    public String getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public String getFailureCause() {
        return this.failureCause;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setApi(String api) {
        this.api = api;
    }

    @Generated
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Generated
    public void setPlan(String plan) {
        this.plan = plan;
    }

    @Generated
    public void setApplication(String application) {
        this.application = application;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setClientCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
    }

    @Generated
    public void setProcessedAt(Date processedAt) {
        this.processedAt = processedAt;
    }

    @Generated
    public void setRequest(String request) {
        this.request = request;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @Generated
    public void setConsumerStatus(ConsumerStatus consumerStatus) {
        this.consumerStatus = consumerStatus;
    }

    @Generated
    public void setProcessedBy(String processedBy) {
        this.processedBy = processedBy;
    }

    @Generated
    public void setSubscribedBy(String subscribedBy) {
        this.subscribedBy = subscribedBy;
    }

    @Generated
    public void setStartingAt(Date startingAt) {
        this.startingAt = startingAt;
    }

    @Generated
    public void setEndingAt(Date endingAt) {
        this.endingAt = endingAt;
    }

    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setClosedAt(Date closedAt) {
        this.closedAt = closedAt;
    }

    @Generated
    public void setPausedAt(Date pausedAt) {
        this.pausedAt = pausedAt;
    }

    @Generated
    public void setConsumerPausedAt(Date consumerPausedAt) {
        this.consumerPausedAt = consumerPausedAt;
    }

    @Generated
    public void setGeneralConditionsContentRevision(Integer generalConditionsContentRevision) {
        this.generalConditionsContentRevision = generalConditionsContentRevision;
    }

    @Generated
    public void setGeneralConditionsContentPageId(String generalConditionsContentPageId) {
        this.generalConditionsContentPageId = generalConditionsContentPageId;
    }

    @Generated
    public void setGeneralConditionsAccepted(Boolean generalConditionsAccepted) {
        this.generalConditionsAccepted = generalConditionsAccepted;
    }

    @Generated
    public void setDaysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
    }

    @Generated
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setType(Type type) {
        this.type = type;
    }

    @Generated
    public void setFailureCause(String failureCause) {
        this.failureCause = failureCause;
    }

    @Generated
    public String toString() {
        return "Subscription(id=" + this.getId() + ", api=" + this.getApi() + ", environmentId=" + this.getEnvironmentId() + ", plan=" + this.getPlan() + ", application=" + this.getApplication() + ", clientId=" + this.getClientId() + ", clientCertificate=" + this.getClientCertificate() + ", processedAt=" + this.getProcessedAt() + ", request=" + this.getRequest() + ", reason=" + this.getReason() + ", status=" + this.getStatus() + ", consumerStatus=" + this.getConsumerStatus() + ", processedBy=" + this.getProcessedBy() + ", subscribedBy=" + this.getSubscribedBy() + ", startingAt=" + this.getStartingAt() + ", endingAt=" + this.getEndingAt() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", closedAt=" + this.getClosedAt() + ", pausedAt=" + this.getPausedAt() + ", consumerPausedAt=" + this.getConsumerPausedAt() + ", generalConditionsContentRevision=" + this.getGeneralConditionsContentRevision() + ", generalConditionsContentPageId=" + this.getGeneralConditionsContentPageId() + ", generalConditionsAccepted=" + this.getGeneralConditionsAccepted() + ", daysToExpirationOnLastNotification=" + this.getDaysToExpirationOnLastNotification() + ", configuration=" + this.getConfiguration() + ", metadata=" + this.getMetadata() + ", type=" + this.getType() + ", failureCause=" + this.getFailureCause() + ")";
    }

    @Generated
    public Subscription(String id, String api, String environmentId, String plan, String application, String clientId, String clientCertificate, Date processedAt, String request, String reason, Status status, ConsumerStatus consumerStatus, String processedBy, String subscribedBy, Date startingAt, Date endingAt, Date createdAt, Date updatedAt, Date closedAt, Date pausedAt, Date consumerPausedAt, Integer generalConditionsContentRevision, String generalConditionsContentPageId, Boolean generalConditionsAccepted, Integer daysToExpirationOnLastNotification, String configuration, Map<String, String> metadata, Type type, String failureCause) {
        this.id = id;
        this.api = api;
        this.environmentId = environmentId;
        this.plan = plan;
        this.application = application;
        this.clientId = clientId;
        this.clientCertificate = clientCertificate;
        this.processedAt = processedAt;
        this.request = request;
        this.reason = reason;
        this.status = status;
        this.consumerStatus = consumerStatus;
        this.processedBy = processedBy;
        this.subscribedBy = subscribedBy;
        this.startingAt = startingAt;
        this.endingAt = endingAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.closedAt = closedAt;
        this.pausedAt = pausedAt;
        this.consumerPausedAt = consumerPausedAt;
        this.generalConditionsContentRevision = generalConditionsContentRevision;
        this.generalConditionsContentPageId = generalConditionsContentPageId;
        this.generalConditionsAccepted = generalConditionsAccepted;
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
        this.configuration = configuration;
        this.metadata = metadata;
        this.type = type;
        this.failureCause = failureCause;
    }

    @Generated
    public Subscription() {
    }

    public static enum ConsumerStatus {
        STARTED,
        STOPPED,
        FAILURE;

    }

    public static enum Type {
        STANDARD,
        PUSH;

    }

    public static enum Status {
        PENDING,
        REJECTED,
        ACCEPTED,
        CLOSED,
        PAUSED;

    }

    @Generated
    public static class SubscriptionBuilder {
        @Generated
        private String id;
        @Generated
        private String api;
        @Generated
        private String environmentId;
        @Generated
        private String plan;
        @Generated
        private String application;
        @Generated
        private String clientId;
        @Generated
        private String clientCertificate;
        @Generated
        private Date processedAt;
        @Generated
        private String request;
        @Generated
        private String reason;
        @Generated
        private Status status;
        @Generated
        private ConsumerStatus consumerStatus;
        @Generated
        private String processedBy;
        @Generated
        private String subscribedBy;
        @Generated
        private Date startingAt;
        @Generated
        private Date endingAt;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private Date closedAt;
        @Generated
        private Date pausedAt;
        @Generated
        private Date consumerPausedAt;
        @Generated
        private Integer generalConditionsContentRevision;
        @Generated
        private String generalConditionsContentPageId;
        @Generated
        private Boolean generalConditionsAccepted;
        @Generated
        private Integer daysToExpirationOnLastNotification;
        @Generated
        private String configuration;
        @Generated
        private Map<String, String> metadata;
        @Generated
        private Type type;
        @Generated
        private String failureCause;

        @Generated
        SubscriptionBuilder() {
        }

        @Generated
        public SubscriptionBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public SubscriptionBuilder api(String api) {
            this.api = api;
            return this;
        }

        @Generated
        public SubscriptionBuilder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Generated
        public SubscriptionBuilder plan(String plan) {
            this.plan = plan;
            return this;
        }

        @Generated
        public SubscriptionBuilder application(String application) {
            this.application = application;
            return this;
        }

        @Generated
        public SubscriptionBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Generated
        public SubscriptionBuilder clientCertificate(String clientCertificate) {
            this.clientCertificate = clientCertificate;
            return this;
        }

        @Generated
        public SubscriptionBuilder processedAt(Date processedAt) {
            this.processedAt = processedAt;
            return this;
        }

        @Generated
        public SubscriptionBuilder request(String request) {
            this.request = request;
            return this;
        }

        @Generated
        public SubscriptionBuilder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Generated
        public SubscriptionBuilder status(Status status) {
            this.status = status;
            return this;
        }

        @Generated
        public SubscriptionBuilder consumerStatus(ConsumerStatus consumerStatus) {
            this.consumerStatus = consumerStatus;
            return this;
        }

        @Generated
        public SubscriptionBuilder processedBy(String processedBy) {
            this.processedBy = processedBy;
            return this;
        }

        @Generated
        public SubscriptionBuilder subscribedBy(String subscribedBy) {
            this.subscribedBy = subscribedBy;
            return this;
        }

        @Generated
        public SubscriptionBuilder startingAt(Date startingAt) {
            this.startingAt = startingAt;
            return this;
        }

        @Generated
        public SubscriptionBuilder endingAt(Date endingAt) {
            this.endingAt = endingAt;
            return this;
        }

        @Generated
        public SubscriptionBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public SubscriptionBuilder updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public SubscriptionBuilder closedAt(Date closedAt) {
            this.closedAt = closedAt;
            return this;
        }

        @Generated
        public SubscriptionBuilder pausedAt(Date pausedAt) {
            this.pausedAt = pausedAt;
            return this;
        }

        @Generated
        public SubscriptionBuilder consumerPausedAt(Date consumerPausedAt) {
            this.consumerPausedAt = consumerPausedAt;
            return this;
        }

        @Generated
        public SubscriptionBuilder generalConditionsContentRevision(Integer generalConditionsContentRevision) {
            this.generalConditionsContentRevision = generalConditionsContentRevision;
            return this;
        }

        @Generated
        public SubscriptionBuilder generalConditionsContentPageId(String generalConditionsContentPageId) {
            this.generalConditionsContentPageId = generalConditionsContentPageId;
            return this;
        }

        @Generated
        public SubscriptionBuilder generalConditionsAccepted(Boolean generalConditionsAccepted) {
            this.generalConditionsAccepted = generalConditionsAccepted;
            return this;
        }

        @Generated
        public SubscriptionBuilder daysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
            this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
            return this;
        }

        @Generated
        public SubscriptionBuilder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public SubscriptionBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public SubscriptionBuilder type(Type type) {
            this.type = type;
            return this;
        }

        @Generated
        public SubscriptionBuilder failureCause(String failureCause) {
            this.failureCause = failureCause;
            return this;
        }

        @Generated
        public Subscription build() {
            return new Subscription(this.id, this.api, this.environmentId, this.plan, this.application, this.clientId, this.clientCertificate, this.processedAt, this.request, this.reason, this.status, this.consumerStatus, this.processedBy, this.subscribedBy, this.startingAt, this.endingAt, this.createdAt, this.updatedAt, this.closedAt, this.pausedAt, this.consumerPausedAt, this.generalConditionsContentRevision, this.generalConditionsContentPageId, this.generalConditionsAccepted, this.daysToExpirationOnLastNotification, this.configuration, this.metadata, this.type, this.failureCause);
        }

        @Generated
        public String toString() {
            return "Subscription.SubscriptionBuilder(id=" + this.id + ", api=" + this.api + ", environmentId=" + this.environmentId + ", plan=" + this.plan + ", application=" + this.application + ", clientId=" + this.clientId + ", clientCertificate=" + this.clientCertificate + ", processedAt=" + this.processedAt + ", request=" + this.request + ", reason=" + this.reason + ", status=" + this.status + ", consumerStatus=" + this.consumerStatus + ", processedBy=" + this.processedBy + ", subscribedBy=" + this.subscribedBy + ", startingAt=" + this.startingAt + ", endingAt=" + this.endingAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", closedAt=" + this.closedAt + ", pausedAt=" + this.pausedAt + ", consumerPausedAt=" + this.consumerPausedAt + ", generalConditionsContentRevision=" + this.generalConditionsContentRevision + ", generalConditionsContentPageId=" + this.generalConditionsContentPageId + ", generalConditionsAccepted=" + this.generalConditionsAccepted + ", daysToExpirationOnLastNotification=" + this.daysToExpirationOnLastNotification + ", configuration=" + this.configuration + ", metadata=" + this.metadata + ", type=" + this.type + ", failureCause=" + this.failureCause + ")";
        }
    }

    public static enum AuditEvent implements Audit.ApiAuditEvent
    {
        SUBSCRIPTION_CREATED,
        SUBSCRIPTION_UPDATED,
        SUBSCRIPTION_DELETED,
        SUBSCRIPTION_CLOSED,
        SUBSCRIPTION_PAUSED,
        SUBSCRIPTION_RESUMED,
        SUBSCRIPTION_PAUSED_BY_CONSUMER,
        SUBSCRIPTION_RESUMED_BY_CONSUMER;

    }
}

