/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api.search;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.Visibility;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ApiCriteria {
    private Collection<String> ids;
    private Collection<String> groups;
    private String category;
    private String label;
    private LifecycleState state;
    private Visibility visibility;
    private String version;
    private String name;
    private List<ApiLifecycleState> lifecycleStates;
    private String environmentId;
    private List<String> environments;
    private String crossId;
    private List<DefinitionVersion> definitionVersion;
    private String integrationId;

    ApiCriteria(Builder builder) {
        this.ids = builder.ids;
        this.groups = builder.groups;
        this.category = builder.category;
        this.label = builder.label;
        this.state = builder.state;
        this.visibility = builder.visibility;
        this.version = builder.version;
        this.name = builder.name;
        this.lifecycleStates = builder.lifecycleStates;
        this.environmentId = builder.environmentId;
        this.environments = builder.environments;
        this.crossId = builder.crossId;
        this.definitionVersion = builder.definitionVersion;
        this.integrationId = builder.integrationId;
    }

    public Collection<String> getIds() {
        return this.ids;
    }

    public Collection<String> getGroups() {
        return this.groups;
    }

    public String getCategory() {
        return this.category;
    }

    public String getLabel() {
        return this.label;
    }

    public LifecycleState getState() {
        return this.state;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public List<ApiLifecycleState> getLifecycleStates() {
        return this.lifecycleStates;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public List<String> getEnvironments() {
        return this.environments;
    }

    public String getCrossId() {
        return this.crossId;
    }

    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    public List<DefinitionVersion> getDefinitionVersion() {
        return this.definitionVersion;
    }

    public void setDefinitionVersion(List<DefinitionVersion> definitionVersion) {
        this.definitionVersion = definitionVersion;
    }

    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApiCriteria)) {
            return false;
        }
        ApiCriteria that = (ApiCriteria)o;
        return Objects.equals(this.ids, that.ids) && Objects.equals(this.groups, that.groups) && Objects.equals(this.category, that.category) && Objects.equals(this.label, that.label) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals((Object)this.visibility, (Object)that.visibility) && Objects.equals(this.version, that.version) && Objects.equals(this.name, that.name) && Objects.equals(this.lifecycleStates, that.lifecycleStates) && Objects.equals(this.environmentId, that.environmentId) && Objects.equals(this.environments, that.environments) && Objects.equals(this.crossId, that.crossId) && Objects.equals(this.definitionVersion, that.definitionVersion) && Objects.equals(this.integrationId, that.integrationId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ids, this.groups, this.category, this.label, this.state, this.visibility, this.version, this.name, this.lifecycleStates, this.environmentId, this.environments, this.crossId, this.definitionVersion, this.integrationId});
    }

    public static class Builder {
        private Collection<String> ids;
        private Collection<String> groups;
        private String category;
        private String label;
        private LifecycleState state;
        private Visibility visibility;
        private String version;
        private String name;
        private List<ApiLifecycleState> lifecycleStates;
        private String environmentId;
        private List<String> environments;
        private String crossId;
        private List<DefinitionVersion> definitionVersion;
        private String integrationId;

        public Builder ids(String ... id) {
            this.ids = Set.of(id);
            return this;
        }

        public Builder ids(Collection<String> ids) {
            this.ids = Set.copyOf(ids);
            return this;
        }

        public Builder groups(String ... group) {
            this.groups = Arrays.asList(group);
            return this;
        }

        public Builder groups(Collection<String> groups) {
            this.groups = groups;
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder state(LifecycleState state) {
            this.state = state;
            return this;
        }

        public Builder visibility(Visibility visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder lifecycleStates(List<ApiLifecycleState> lifecycleStates) {
            this.lifecycleStates = lifecycleStates;
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder environments(List<String> environments) {
            this.environments = environments;
            return this;
        }

        public Builder crossId(String crossId) {
            this.crossId = crossId;
            return this;
        }

        public Builder definitionVersion(List<DefinitionVersion> definitionVersion) {
            this.definitionVersion = definitionVersion;
            return this;
        }

        public Builder integrationId(String integrationId) {
            this.integrationId = integrationId;
            return this;
        }

        public ApiCriteria build() {
            return new ApiCriteria(this);
        }
    }
}

