/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.model;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.Visibility;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public class Api {
    public static final String ORIGIN_KUBERNETES = "kubernetes";
    public static final String ORIGIN_MANAGEMENT = "management";
    public static final String ORIGIN_INTEGRATION = "integration";
    public static final String MODE_FULLY_MANAGED = "fully_managed";
    public static final String MODE_API_DEFINITION_ONLY = "api_definition_only";
    private String id;
    private String environmentId;
    private String crossId;
    private String name;
    private String description;
    private String version;
    private String origin = "management";
    private String syncFrom = "management".toUpperCase();
    private String mode;
    private String integrationId;
    private DefinitionVersion definitionVersion;
    private String definition;
    private ApiType type;
    private Date deployedAt;
    private Date createdAt;
    private Date updatedAt;
    private Visibility visibility;
    private LifecycleState lifecycleState;
    private String picture;
    private Set<String> groups;
    private Set<String> categories;
    private List<String> labels;
    private boolean disableMembershipNotifications;
    private ApiLifecycleState apiLifecycleState = ApiLifecycleState.CREATED;
    private String background;

    public Api(Api cloned) {
        this.id = cloned.id;
        this.crossId = cloned.crossId;
        this.environmentId = cloned.environmentId;
        this.name = cloned.name;
        this.description = cloned.description;
        this.origin = cloned.origin;
        this.mode = cloned.mode;
        this.version = cloned.version;
        this.type = cloned.type;
        this.definitionVersion = cloned.definitionVersion;
        this.definition = cloned.definition;
        this.deployedAt = cloned.deployedAt;
        this.createdAt = cloned.createdAt;
        this.updatedAt = cloned.updatedAt;
        this.visibility = cloned.visibility;
        this.lifecycleState = cloned.lifecycleState;
        this.picture = cloned.picture;
        this.background = cloned.background;
        this.groups = cloned.groups;
        this.categories = cloned.categories;
        this.labels = cloned.labels;
        this.apiLifecycleState = cloned.apiLifecycleState;
        this.disableMembershipNotifications = cloned.disableMembershipNotifications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Api api = (Api)o;
        return Objects.equals(this.id, api.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Generated
    public static ApiBuilder builder() {
        return new ApiBuilder();
    }

    @Generated
    public ApiBuilder toBuilder() {
        return new ApiBuilder().id(this.id).environmentId(this.environmentId).crossId(this.crossId).name(this.name).description(this.description).version(this.version).origin(this.origin).syncFrom(this.syncFrom).mode(this.mode).integrationId(this.integrationId).definitionVersion(this.definitionVersion).definition(this.definition).type(this.type).deployedAt(this.deployedAt).createdAt(this.createdAt).updatedAt(this.updatedAt).visibility(this.visibility).lifecycleState(this.lifecycleState).picture(this.picture).groups(this.groups).categories(this.categories).labels(this.labels).disableMembershipNotifications(this.disableMembershipNotifications).apiLifecycleState(this.apiLifecycleState).background(this.background);
    }

    @Generated
    public Api() {
    }

    @Generated
    public Api(String id, String environmentId, String crossId, String name, String description, String version, String origin, String syncFrom, String mode, String integrationId, DefinitionVersion definitionVersion, String definition, ApiType type, Date deployedAt, Date createdAt, Date updatedAt, Visibility visibility, LifecycleState lifecycleState, String picture, Set<String> groups, Set<String> categories, List<String> labels, boolean disableMembershipNotifications, ApiLifecycleState apiLifecycleState, String background) {
        this.id = id;
        this.environmentId = environmentId;
        this.crossId = crossId;
        this.name = name;
        this.description = description;
        this.version = version;
        this.origin = origin;
        this.syncFrom = syncFrom;
        this.mode = mode;
        this.integrationId = integrationId;
        this.definitionVersion = definitionVersion;
        this.definition = definition;
        this.type = type;
        this.deployedAt = deployedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.visibility = visibility;
        this.lifecycleState = lifecycleState;
        this.picture = picture;
        this.groups = groups;
        this.categories = categories;
        this.labels = labels;
        this.disableMembershipNotifications = disableMembershipNotifications;
        this.apiLifecycleState = apiLifecycleState;
        this.background = background;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getOrigin() {
        return this.origin;
    }

    @Generated
    public String getSyncFrom() {
        return this.syncFrom;
    }

    @Generated
    public String getMode() {
        return this.mode;
    }

    @Generated
    public String getIntegrationId() {
        return this.integrationId;
    }

    @Generated
    public DefinitionVersion getDefinitionVersion() {
        return this.definitionVersion;
    }

    @Generated
    public String getDefinition() {
        return this.definition;
    }

    @Generated
    public ApiType getType() {
        return this.type;
    }

    @Generated
    public Date getDeployedAt() {
        return this.deployedAt;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Generated
    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    @Generated
    public String getPicture() {
        return this.picture;
    }

    @Generated
    public Set<String> getGroups() {
        return this.groups;
    }

    @Generated
    public Set<String> getCategories() {
        return this.categories;
    }

    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Generated
    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    @Generated
    public ApiLifecycleState getApiLifecycleState() {
        return this.apiLifecycleState;
    }

    @Generated
    public String getBackground() {
        return this.background;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    @Generated
    public void setSyncFrom(String syncFrom) {
        this.syncFrom = syncFrom;
    }

    @Generated
    public void setMode(String mode) {
        this.mode = mode;
    }

    @Generated
    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    @Generated
    public void setDefinitionVersion(DefinitionVersion definitionVersion) {
        this.definitionVersion = definitionVersion;
    }

    @Generated
    public void setDefinition(String definition) {
        this.definition = definition;
    }

    @Generated
    public void setType(ApiType type) {
        this.type = type;
    }

    @Generated
    public void setDeployedAt(Date deployedAt) {
        this.deployedAt = deployedAt;
    }

    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Generated
    public void setLifecycleState(LifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @Generated
    public void setPicture(String picture) {
        this.picture = picture;
    }

    @Generated
    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @Generated
    public void setCategories(Set<String> categories) {
        this.categories = categories;
    }

    @Generated
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Generated
    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    @Generated
    public void setApiLifecycleState(ApiLifecycleState apiLifecycleState) {
        this.apiLifecycleState = apiLifecycleState;
    }

    @Generated
    public void setBackground(String background) {
        this.background = background;
    }

    @Generated
    public String toString() {
        return "Api(id=" + this.getId() + ", environmentId=" + this.getEnvironmentId() + ", crossId=" + this.getCrossId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", origin=" + this.getOrigin() + ", syncFrom=" + this.getSyncFrom() + ", mode=" + this.getMode() + ", integrationId=" + this.getIntegrationId() + ", definitionVersion=" + this.getDefinitionVersion() + ", definition=" + this.getDefinition() + ", type=" + this.getType() + ", deployedAt=" + this.getDeployedAt() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", visibility=" + this.getVisibility() + ", lifecycleState=" + this.getLifecycleState() + ", picture=" + this.getPicture() + ", groups=" + this.getGroups() + ", categories=" + this.getCategories() + ", labels=" + this.getLabels() + ", disableMembershipNotifications=" + this.isDisableMembershipNotifications() + ", apiLifecycleState=" + this.getApiLifecycleState() + ", background=" + this.getBackground() + ")";
    }

    @Generated
    public Api withId(String id) {
        return this.id == id ? this : new Api(id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withEnvironmentId(String environmentId) {
        return this.environmentId == environmentId ? this : new Api(this.id, environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withCrossId(String crossId) {
        return this.crossId == crossId ? this : new Api(this.id, this.environmentId, crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withName(String name) {
        return this.name == name ? this : new Api(this.id, this.environmentId, this.crossId, name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withDescription(String description) {
        return this.description == description ? this : new Api(this.id, this.environmentId, this.crossId, this.name, description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withVersion(String version) {
        return this.version == version ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withOrigin(String origin) {
        return this.origin == origin ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withSyncFrom(String syncFrom) {
        return this.syncFrom == syncFrom ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withMode(String mode) {
        return this.mode == mode ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withIntegrationId(String integrationId) {
        return this.integrationId == integrationId ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withDefinitionVersion(DefinitionVersion definitionVersion) {
        return this.definitionVersion == definitionVersion ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withDefinition(String definition) {
        return this.definition == definition ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withType(ApiType type) {
        return this.type == type ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withDeployedAt(Date deployedAt) {
        return this.deployedAt == deployedAt ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withCreatedAt(Date createdAt) {
        return this.createdAt == createdAt ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withUpdatedAt(Date updatedAt) {
        return this.updatedAt == updatedAt ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withVisibility(Visibility visibility) {
        return this.visibility == visibility ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withLifecycleState(LifecycleState lifecycleState) {
        return this.lifecycleState == lifecycleState ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withPicture(String picture) {
        return this.picture == picture ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withGroups(Set<String> groups) {
        return this.groups == groups ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withCategories(Set<String> categories) {
        return this.categories == categories ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withLabels(List<String> labels) {
        return this.labels == labels ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withDisableMembershipNotifications(boolean disableMembershipNotifications) {
        return this.disableMembershipNotifications == disableMembershipNotifications ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, disableMembershipNotifications, this.apiLifecycleState, this.background);
    }

    @Generated
    public Api withApiLifecycleState(ApiLifecycleState apiLifecycleState) {
        return this.apiLifecycleState == apiLifecycleState ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, apiLifecycleState, this.background);
    }

    @Generated
    public Api withBackground(String background) {
        return this.background == background ? this : new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, background);
    }

    @Generated
    public static class ApiBuilder {
        @Generated
        private String id;
        @Generated
        private String environmentId;
        @Generated
        private String crossId;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String version;
        @Generated
        private String origin;
        @Generated
        private String syncFrom;
        @Generated
        private String mode;
        @Generated
        private String integrationId;
        @Generated
        private DefinitionVersion definitionVersion;
        @Generated
        private String definition;
        @Generated
        private ApiType type;
        @Generated
        private Date deployedAt;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private Visibility visibility;
        @Generated
        private LifecycleState lifecycleState;
        @Generated
        private String picture;
        @Generated
        private Set<String> groups;
        @Generated
        private Set<String> categories;
        @Generated
        private List<String> labels;
        @Generated
        private boolean disableMembershipNotifications;
        @Generated
        private ApiLifecycleState apiLifecycleState;
        @Generated
        private String background;

        @Generated
        ApiBuilder() {
        }

        @Generated
        public ApiBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ApiBuilder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Generated
        public ApiBuilder crossId(String crossId) {
            this.crossId = crossId;
            return this;
        }

        @Generated
        public ApiBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ApiBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public ApiBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public ApiBuilder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Generated
        public ApiBuilder syncFrom(String syncFrom) {
            this.syncFrom = syncFrom;
            return this;
        }

        @Generated
        public ApiBuilder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Generated
        public ApiBuilder integrationId(String integrationId) {
            this.integrationId = integrationId;
            return this;
        }

        @Generated
        public ApiBuilder definitionVersion(DefinitionVersion definitionVersion) {
            this.definitionVersion = definitionVersion;
            return this;
        }

        @Generated
        public ApiBuilder definition(String definition) {
            this.definition = definition;
            return this;
        }

        @Generated
        public ApiBuilder type(ApiType type) {
            this.type = type;
            return this;
        }

        @Generated
        public ApiBuilder deployedAt(Date deployedAt) {
            this.deployedAt = deployedAt;
            return this;
        }

        @Generated
        public ApiBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public ApiBuilder updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public ApiBuilder visibility(Visibility visibility) {
            this.visibility = visibility;
            return this;
        }

        @Generated
        public ApiBuilder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        @Generated
        public ApiBuilder picture(String picture) {
            this.picture = picture;
            return this;
        }

        @Generated
        public ApiBuilder groups(Set<String> groups) {
            this.groups = groups;
            return this;
        }

        @Generated
        public ApiBuilder categories(Set<String> categories) {
            this.categories = categories;
            return this;
        }

        @Generated
        public ApiBuilder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        @Generated
        public ApiBuilder disableMembershipNotifications(boolean disableMembershipNotifications) {
            this.disableMembershipNotifications = disableMembershipNotifications;
            return this;
        }

        @Generated
        public ApiBuilder apiLifecycleState(ApiLifecycleState apiLifecycleState) {
            this.apiLifecycleState = apiLifecycleState;
            return this;
        }

        @Generated
        public ApiBuilder background(String background) {
            this.background = background;
            return this;
        }

        @Generated
        public Api build() {
            return new Api(this.id, this.environmentId, this.crossId, this.name, this.description, this.version, this.origin, this.syncFrom, this.mode, this.integrationId, this.definitionVersion, this.definition, this.type, this.deployedAt, this.createdAt, this.updatedAt, this.visibility, this.lifecycleState, this.picture, this.groups, this.categories, this.labels, this.disableMembershipNotifications, this.apiLifecycleState, this.background);
        }

        @Generated
        public String toString() {
            return "Api.ApiBuilder(id=" + this.id + ", environmentId=" + this.environmentId + ", crossId=" + this.crossId + ", name=" + this.name + ", description=" + this.description + ", version=" + this.version + ", origin=" + this.origin + ", syncFrom=" + this.syncFrom + ", mode=" + this.mode + ", integrationId=" + this.integrationId + ", definitionVersion=" + this.definitionVersion + ", definition=" + this.definition + ", type=" + this.type + ", deployedAt=" + this.deployedAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", visibility=" + this.visibility + ", lifecycleState=" + this.lifecycleState + ", picture=" + this.picture + ", groups=" + this.groups + ", categories=" + this.categories + ", labels=" + this.labels + ", disableMembershipNotifications=" + this.disableMembershipNotifications + ", apiLifecycleState=" + this.apiLifecycleState + ", background=" + this.background + ")";
        }
    }

    public static enum AuditEvent implements Audit.ApiAuditEvent
    {
        API_CREATED,
        API_UPDATED,
        API_DELETED,
        API_ROLLBACKED,
        API_LOGGING_ENABLED,
        API_LOGGING_DISABLED,
        API_LOGGING_UPDATED;

    }
}

