/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.model;

import io.gravitee.repository.management.model.Audit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class ApiKey
implements Serializable {
    private String id;
    private String key;
    private List<String> subscriptions = new ArrayList<String>();
    @Deprecated(since="3.17.0", forRemoval=true)
    private String subscription;
    @Deprecated(since="3.17.0", forRemoval=true)
    private String plan;
    @Deprecated(since="3.17.0", forRemoval=true)
    private String api;
    private String application;
    private Date expireAt;
    private Date createdAt;
    private Date updatedAt;
    private boolean revoked;
    private boolean paused;
    private Date revokedAt;
    private Integer daysToExpirationOnLastNotification;

    public ApiKey(ApiKey cloned) {
        this.id = cloned.id;
        this.key = cloned.key;
        this.subscriptions = cloned.subscriptions;
        this.application = cloned.application;
        this.plan = cloned.plan;
        this.expireAt = cloned.expireAt;
        this.createdAt = cloned.createdAt;
        this.updatedAt = cloned.updatedAt;
        this.revoked = cloned.revoked;
        this.revokedAt = cloned.revokedAt;
        this.paused = cloned.paused;
        this.daysToExpirationOnLastNotification = cloned.daysToExpirationOnLastNotification;
        this.api = cloned.api;
    }

    public ApiKey revoke() {
        ApiKey revokedApiKey = new ApiKey(this);
        Date now = new Date();
        revokedApiKey.setRevoked(true);
        revokedApiKey.setUpdatedAt(now);
        revokedApiKey.setRevokedAt(now);
        return revokedApiKey;
    }

    public void setRevoked(boolean revoked) {
        this.revoked = revoked;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setExpireAt(Date expireAt) {
        this.expireAt = expireAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setRevokedAt(Date revokedAt) {
        this.revokedAt = revokedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setSubscriptions(List<String> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setDaysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public String getSubscription() {
        return this.subscription;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public String getPlan() {
        return this.plan;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public void setPlan(String plan) {
        this.plan = plan;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public String getApi() {
        return this.api;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public void setApi(String api) {
        this.api = api;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiKey apiKey = (ApiKey)o;
        return Objects.equals(this.id, apiKey.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Generated
    public static ApiKeyBuilder builder() {
        return new ApiKeyBuilder();
    }

    @Generated
    public ApiKeyBuilder toBuilder() {
        return new ApiKeyBuilder().id(this.id).key(this.key).subscriptions(this.subscriptions).subscription(this.subscription).plan(this.plan).api(this.api).application(this.application).expireAt(this.expireAt).createdAt(this.createdAt).updatedAt(this.updatedAt).revoked(this.revoked).paused(this.paused).revokedAt(this.revokedAt).daysToExpirationOnLastNotification(this.daysToExpirationOnLastNotification);
    }

    @Generated
    public ApiKey() {
    }

    @Generated
    public ApiKey(String id, String key, List<String> subscriptions, String subscription, String plan, String api, String application, Date expireAt, Date createdAt, Date updatedAt, boolean revoked, boolean paused, Date revokedAt, Integer daysToExpirationOnLastNotification) {
        this.id = id;
        this.key = key;
        this.subscriptions = subscriptions;
        this.subscription = subscription;
        this.plan = plan;
        this.api = api;
        this.application = application;
        this.expireAt = expireAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.revoked = revoked;
        this.paused = paused;
        this.revokedAt = revokedAt;
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
    }

    @Generated
    public String toString() {
        return "ApiKey(id=" + this.getId() + ", key=" + this.getKey() + ", subscriptions=" + this.getSubscriptions() + ", subscription=" + this.getSubscription() + ", plan=" + this.getPlan() + ", api=" + this.getApi() + ", application=" + this.getApplication() + ", expireAt=" + this.getExpireAt() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", revoked=" + this.isRevoked() + ", paused=" + this.isPaused() + ", revokedAt=" + this.getRevokedAt() + ", daysToExpirationOnLastNotification=" + this.getDaysToExpirationOnLastNotification() + ")";
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public List<String> getSubscriptions() {
        return this.subscriptions;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public Date getExpireAt() {
        return this.expireAt;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public boolean isRevoked() {
        return this.revoked;
    }

    @Generated
    public boolean isPaused() {
        return this.paused;
    }

    @Generated
    public Date getRevokedAt() {
        return this.revokedAt;
    }

    @Generated
    public Integer getDaysToExpirationOnLastNotification() {
        return this.daysToExpirationOnLastNotification;
    }

    @Generated
    public static class ApiKeyBuilder {
        @Generated
        private String id;
        @Generated
        private String key;
        @Generated
        private List<String> subscriptions;
        @Generated
        private String subscription;
        @Generated
        private String plan;
        @Generated
        private String api;
        @Generated
        private String application;
        @Generated
        private Date expireAt;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private boolean revoked;
        @Generated
        private boolean paused;
        @Generated
        private Date revokedAt;
        @Generated
        private Integer daysToExpirationOnLastNotification;

        @Generated
        ApiKeyBuilder() {
        }

        @Generated
        public ApiKeyBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ApiKeyBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public ApiKeyBuilder subscriptions(List<String> subscriptions) {
            this.subscriptions = subscriptions;
            return this;
        }

        @Deprecated
        @Generated
        public ApiKeyBuilder subscription(String subscription) {
            this.subscription = subscription;
            return this;
        }

        @Deprecated
        @Generated
        public ApiKeyBuilder plan(String plan) {
            this.plan = plan;
            return this;
        }

        @Deprecated
        @Generated
        public ApiKeyBuilder api(String api) {
            this.api = api;
            return this;
        }

        @Generated
        public ApiKeyBuilder application(String application) {
            this.application = application;
            return this;
        }

        @Generated
        public ApiKeyBuilder expireAt(Date expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Generated
        public ApiKeyBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public ApiKeyBuilder updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public ApiKeyBuilder revoked(boolean revoked) {
            this.revoked = revoked;
            return this;
        }

        @Generated
        public ApiKeyBuilder paused(boolean paused) {
            this.paused = paused;
            return this;
        }

        @Generated
        public ApiKeyBuilder revokedAt(Date revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        @Generated
        public ApiKeyBuilder daysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
            this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
            return this;
        }

        @Generated
        public ApiKey build() {
            return new ApiKey(this.id, this.key, this.subscriptions, this.subscription, this.plan, this.api, this.application, this.expireAt, this.createdAt, this.updatedAt, this.revoked, this.paused, this.revokedAt, this.daysToExpirationOnLastNotification);
        }

        @Generated
        public String toString() {
            return "ApiKey.ApiKeyBuilder(id=" + this.id + ", key=" + this.key + ", subscriptions=" + this.subscriptions + ", subscription=" + this.subscription + ", plan=" + this.plan + ", api=" + this.api + ", application=" + this.application + ", expireAt=" + this.expireAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", revoked=" + this.revoked + ", paused=" + this.paused + ", revokedAt=" + this.revokedAt + ", daysToExpirationOnLastNotification=" + this.daysToExpirationOnLastNotification + ")";
        }
    }

    public static enum AuditEvent implements Audit.ApiAuditEvent
    {
        APIKEY_CREATED,
        APIKEY_RENEWED,
        APIKEY_REVOKED,
        APIKEY_EXPIRED,
        APIKEY_REACTIVATED;

    }
}

