/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api.search;

import io.gravitee.repository.management.model.ApplicationStatus;
import java.util.Objects;
import java.util.Set;

public class ApplicationCriteria {
    private Set<String> ids;
    private String name;
    private Set<String> environmentIds;
    private ApplicationStatus status;
    private Set<String> groups;

    ApplicationCriteria(Builder builder) {
        this.ids = builder.ids;
        this.name = builder.name;
        this.environmentIds = builder.environmentIds;
        this.status = builder.status;
        this.groups = builder.groups;
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getEnvironmentIds() {
        return this.environmentIds;
    }

    public ApplicationStatus getStatus() {
        return this.status;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationCriteria)) {
            return false;
        }
        ApplicationCriteria that = (ApplicationCriteria)o;
        return Objects.equals(this.ids, that.ids) && Objects.equals(this.name, that.name) && Objects.equals(this.environmentIds, that.environmentIds) && Objects.equals((Object)this.status, (Object)that.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ids, this.name, this.environmentIds, this.status});
    }

    public static class Builder {
        private Set<String> ids;
        private String name;
        private Set<String> environmentIds;
        private ApplicationStatus status;
        private Set<String> groups;

        public Builder ids(Set<String> ids) {
            this.ids = ids;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder environmentIds(String ... environmentIds) {
            return this.environmentIds(Set.of(environmentIds));
        }

        public Builder environmentIds(Set<String> environmentIds) {
            this.environmentIds = environmentIds;
            return this;
        }

        public Builder status(ApplicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder groups(Set<String> groups) {
            this.groups = groups;
            return this;
        }

        public ApplicationCriteria build() {
            return new ApplicationCriteria(this);
        }
    }
}

