/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api.search;

import java.util.Objects;

public class ApiFieldFilter {
    private final boolean definitionExcluded;
    private final boolean pictureExcluded;

    public static ApiFieldFilter allFields() {
        return new ApiFieldFilter();
    }

    public static ApiFieldFilter defaultFields() {
        return new Builder().excludeDefinition().excludePicture().build();
    }

    private ApiFieldFilter() {
        this.definitionExcluded = false;
        this.pictureExcluded = false;
    }

    private ApiFieldFilter(Builder builder) {
        this.definitionExcluded = builder.excludeDefinition;
        this.pictureExcluded = builder.excludePicture;
    }

    public boolean isDefinitionExcluded() {
        return this.definitionExcluded;
    }

    public boolean isPictureExcluded() {
        return this.pictureExcluded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApiFieldFilter)) {
            return false;
        }
        ApiFieldFilter that = (ApiFieldFilter)o;
        return this.definitionExcluded == that.definitionExcluded && this.pictureExcluded == that.pictureExcluded;
    }

    public int hashCode() {
        return Objects.hash(this.definitionExcluded, this.pictureExcluded);
    }

    public static class Builder {
        private boolean excludeDefinition;
        private boolean excludePicture;

        public Builder excludeDefinition() {
            this.excludeDefinition = true;
            return this;
        }

        public Builder excludePicture() {
            this.excludePicture = true;
            return this;
        }

        public ApiFieldFilter build() {
            return new ApiFieldFilter(this);
        }
    }
}

