/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api.search;

import io.gravitee.repository.management.model.RatingReferenceType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class RatingCriteria {
    private final Collection<String> referenceIds;
    private RatingReferenceType referenceType;
    private final int gt;

    RatingCriteria(Builder builder) {
        this.referenceIds = builder.referenceIds;
        this.referenceType = builder.referenceType;
        this.gt = builder.gt;
    }

    public Collection<String> getReferenceIds() {
        return this.referenceIds;
    }

    public RatingReferenceType getReferenceType() {
        return this.referenceType;
    }

    public int getGt() {
        return this.gt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RatingCriteria)) {
            return false;
        }
        RatingCriteria that = (RatingCriteria)o;
        return Objects.equals(this.referenceIds, that.referenceIds) && Objects.equals((Object)this.referenceType, (Object)that.referenceType) && Objects.equals(this.gt, that.gt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.referenceIds, this.referenceType, this.gt});
    }

    public static class Builder {
        private Collection<String> referenceIds;
        private RatingReferenceType referenceType = RatingReferenceType.API;
        private int gt = 0;

        public Builder referenceIds(String ... referenceIds) {
            this.referenceIds = Arrays.asList(referenceIds);
            return this;
        }

        public Builder referenceIds(Collection<String> referenceIds) {
            this.referenceIds = referenceIds;
            return this;
        }

        public Builder referenceType(RatingReferenceType referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        public Builder gt(int minRate) {
            this.gt = Math.max(minRate, 0);
            return this;
        }

        public RatingCriteria build() {
            return new RatingCriteria(this);
        }
    }
}

