/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.model;

import io.gravitee.repository.management.model.Audit;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class Subscription
implements Serializable {
    private String id;
    private String api;
    private String plan;
    private String application;
    private String clientId;
    private Date processedAt;
    private String request;
    private String reason;
    private Status status;
    private ConsumerStatus consumerStatus = ConsumerStatus.STARTED;
    private String processedBy;
    private String subscribedBy;
    private Date startingAt;
    private Date endingAt;
    private Date createdAt;
    private Date updatedAt;
    private Date closedAt;
    private Date pausedAt;
    private Date consumerPausedAt;
    private Integer generalConditionsContentRevision;
    private String generalConditionsContentPageId;
    private Boolean generalConditionsAccepted;
    private Integer daysToExpirationOnLastNotification;
    private String configuration;
    private Map<String, String> metadata;
    private Type type = Type.STANDARD;
    private String failureCause;

    public Subscription() {
    }

    public Subscription(Subscription cloned) {
        this.id = cloned.id;
        this.api = cloned.api;
        this.plan = cloned.plan;
        this.application = cloned.application;
        this.processedAt = cloned.processedAt;
        this.reason = cloned.reason;
        this.status = cloned.status;
        this.consumerStatus = cloned.consumerStatus;
        this.processedBy = cloned.processedBy;
        this.subscribedBy = cloned.subscribedBy;
        this.startingAt = cloned.startingAt;
        this.endingAt = cloned.endingAt;
        this.createdAt = cloned.createdAt;
        this.updatedAt = cloned.updatedAt;
        this.closedAt = cloned.closedAt;
        this.pausedAt = cloned.pausedAt;
        this.consumerPausedAt = cloned.consumerPausedAt;
        this.generalConditionsAccepted = cloned.generalConditionsAccepted;
        this.generalConditionsContentRevision = cloned.generalConditionsContentRevision;
        this.generalConditionsContentPageId = cloned.generalConditionsContentPageId;
        this.daysToExpirationOnLastNotification = cloned.daysToExpirationOnLastNotification;
        this.configuration = cloned.configuration;
        this.metadata = cloned.metadata;
        this.type = cloned.type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public String getPlan() {
        return this.plan;
    }

    public void setPlan(String plan) {
        this.plan = plan;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public Date getStartingAt() {
        return this.startingAt;
    }

    public void setStartingAt(Date startingAt) {
        this.startingAt = startingAt;
    }

    public Date getEndingAt() {
        return this.endingAt;
    }

    public void setEndingAt(Date endingAt) {
        this.endingAt = endingAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getProcessedAt() {
        return this.processedAt;
    }

    public void setProcessedAt(Date processedAt) {
        this.processedAt = processedAt;
    }

    public String getProcessedBy() {
        return this.processedBy;
    }

    public void setProcessedBy(String processedBy) {
        this.processedBy = processedBy;
    }

    public String getSubscribedBy() {
        return this.subscribedBy;
    }

    public void setSubscribedBy(String subscribedBy) {
        this.subscribedBy = subscribedBy;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public ConsumerStatus getConsumerStatus() {
        return this.consumerStatus;
    }

    public void setConsumerStatus(ConsumerStatus consumerStatus) {
        this.consumerStatus = consumerStatus;
    }

    public Date getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(Date closedAt) {
        this.closedAt = closedAt;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Date getPausedAt() {
        return this.pausedAt;
    }

    public void setPausedAt(Date pausedAt) {
        this.pausedAt = pausedAt;
    }

    public Date getConsumerPausedAt() {
        return this.consumerPausedAt;
    }

    public void setConsumerPausedAt(Date consumerPausedAt) {
        this.consumerPausedAt = consumerPausedAt;
    }

    public Integer getGeneralConditionsContentRevision() {
        return this.generalConditionsContentRevision;
    }

    public void setGeneralConditionsContentRevision(Integer generalConditionsContentRevision) {
        this.generalConditionsContentRevision = generalConditionsContentRevision;
    }

    public String getGeneralConditionsContentPageId() {
        return this.generalConditionsContentPageId;
    }

    public void setGeneralConditionsContentPageId(String generalConditionsContentPageId) {
        this.generalConditionsContentPageId = generalConditionsContentPageId;
    }

    public Boolean getGeneralConditionsAccepted() {
        return this.generalConditionsAccepted;
    }

    public void setGeneralConditionsAccepted(Boolean generalConditionsAccepted) {
        this.generalConditionsAccepted = generalConditionsAccepted;
    }

    public Integer getDaysToExpirationOnLastNotification() {
        return this.daysToExpirationOnLastNotification;
    }

    public void setDaysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getFailureCause() {
        return this.failureCause;
    }

    public void setFailureCause(String failureCause) {
        this.failureCause = failureCause;
    }

    public boolean canBeStartedByConsumer() {
        return ConsumerStatus.STOPPED.equals((Object)this.consumerStatus) || ConsumerStatus.FAILURE.equals((Object)this.consumerStatus);
    }

    public boolean canBeStoppedByConsumer() {
        return ConsumerStatus.STARTED.equals((Object)this.consumerStatus) || ConsumerStatus.FAILURE.equals((Object)this.consumerStatus);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription that = (Subscription)o;
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public static enum ConsumerStatus {
        STARTED,
        STOPPED,
        FAILURE;

    }

    public static enum Type {
        STANDARD,
        PUSH;

    }

    public static enum Status {
        PENDING,
        REJECTED,
        ACCEPTED,
        CLOSED,
        PAUSED;

    }

    public static enum AuditEvent implements Audit.ApiAuditEvent
    {
        SUBSCRIPTION_CREATED,
        SUBSCRIPTION_UPDATED,
        SUBSCRIPTION_DELETED,
        SUBSCRIPTION_CLOSED,
        SUBSCRIPTION_PAUSED,
        SUBSCRIPTION_RESUMED,
        SUBSCRIPTION_PAUSED_BY_CONSUMER,
        SUBSCRIPTION_RESUMED_BY_CONSUMER;

    }
}

