/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.model;

import io.gravitee.repository.management.model.Audit;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Plan {
    private String id;
    private String crossId;
    private String name;
    private String description;
    private PlanSecurityType security;
    private String securityDefinition;
    private String selectionRule;
    private PlanValidationType validation;
    private PlanType type;
    private PlanMode mode;
    private Status status;
    private int order;
    private String api;
    private Date createdAt;
    private Date updatedAt;
    private Date publishedAt;
    private Date closedAt;
    private String definition;
    private List<String> characteristics;
    private List<String> excludedGroups;
    private Date needRedeployAt;
    private boolean commentRequired;
    private String commentMessage;
    private String generalConditions;
    private Set<String> tags = new HashSet<String>();

    public Plan() {
    }

    public Plan(Plan cloned) {
        this.id = cloned.getId();
        this.crossId = cloned.getCrossId();
        this.name = cloned.getName();
        this.description = cloned.getDescription();
        this.security = cloned.getSecurity();
        this.validation = cloned.getValidation();
        this.type = cloned.getType();
        this.mode = cloned.getMode();
        this.status = cloned.getStatus();
        this.order = cloned.getOrder();
        this.api = cloned.getApi();
        this.createdAt = cloned.getCreatedAt();
        this.updatedAt = cloned.getUpdatedAt();
        this.publishedAt = cloned.getPublishedAt();
        this.closedAt = cloned.getClosedAt();
        this.definition = cloned.getDefinition();
        this.characteristics = cloned.getCharacteristics();
        this.excludedGroups = cloned.getExcludedGroups();
        this.needRedeployAt = cloned.getNeedRedeployAt();
        this.selectionRule = cloned.getSelectionRule();
        this.tags = cloned.getTags();
        this.generalConditions = cloned.getGeneralConditions();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PlanValidationType getValidation() {
        return this.validation;
    }

    public void setValidation(PlanValidationType validation) {
        this.validation = validation;
    }

    public PlanType getType() {
        return this.type;
    }

    public void setType(PlanType type) {
        this.type = type;
    }

    public PlanMode getMode() {
        return this.mode;
    }

    public void setMode(PlanMode mode) {
        this.mode = mode;
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public List<String> getCharacteristics() {
        return this.characteristics;
    }

    public void setCharacteristics(List<String> characteristics) {
        this.characteristics = characteristics;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Date getPublishedAt() {
        return this.publishedAt;
    }

    public void setPublishedAt(Date publishedAt) {
        this.publishedAt = publishedAt;
    }

    public Date getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(Date closedAt) {
        this.closedAt = closedAt;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public PlanSecurityType getSecurity() {
        return this.security;
    }

    public void setSecurity(PlanSecurityType security) {
        this.security = security;
    }

    public String getSecurityDefinition() {
        return this.securityDefinition;
    }

    public void setSecurityDefinition(String securityDefinition) {
        this.securityDefinition = securityDefinition;
    }

    public List<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    public void setExcludedGroups(List<String> excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    public Date getNeedRedeployAt() {
        return this.needRedeployAt;
    }

    public void setNeedRedeployAt(Date needRedeployAt) {
        this.needRedeployAt = needRedeployAt;
    }

    public boolean isCommentRequired() {
        return this.commentRequired;
    }

    public void setCommentRequired(boolean commentRequired) {
        this.commentRequired = commentRequired;
    }

    public String getCommentMessage() {
        return this.commentMessage;
    }

    public void setCommentMessage(String commentMessage) {
        this.commentMessage = commentMessage;
    }

    public String getSelectionRule() {
        return this.selectionRule;
    }

    public void setSelectionRule(String selectionRule) {
        this.selectionRule = selectionRule;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public String getGeneralConditions() {
        return this.generalConditions;
    }

    public void setGeneralConditions(String generalConditions) {
        this.generalConditions = generalConditions;
    }

    public String getCrossId() {
        return this.crossId;
    }

    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plan plan = (Plan)o;
        return this.id != null ? this.id.equals(plan.id) : plan.id == null;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "Plan{id='" + this.id + "'crossId='" + this.crossId + "', api='" + this.api + "', name='" + this.name + "', description='" + this.description + "', validation=" + this.validation + ", excludedGroups=" + this.excludedGroups + ", type=" + this.type + "}";
    }

    public static enum PlanSecurityType {
        KEY_LESS,
        API_KEY,
        OAUTH2,
        JWT;

    }

    public static enum PlanValidationType {
        AUTO,
        MANUAL;

    }

    public static enum PlanType {
        API,
        CATALOG;

    }

    public static enum PlanMode {
        STANDARD,
        PUSH;

    }

    public static enum Status {
        STAGING,
        PUBLISHED,
        CLOSED,
        DEPRECATED;

    }

    public static enum AuditEvent implements Audit.ApiAuditEvent
    {
        PLAN_CREATED,
        PLAN_UPDATED,
        PLAN_DELETED,
        PLAN_PUBLISHED,
        PLAN_CLOSED,
        PLAN_DEPRECATED;

    }
}

