/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api.search;

import io.gravitee.repository.management.model.Subscription;
import java.util.Collection;
import java.util.Collections;

public class SubscriptionCriteria {
    private final Collection<String> apis;
    private final Collection<String> plans;
    private final Collection<Subscription.Status> statuses;
    private final Collection<String> applications;
    private final long from;
    private final long to;
    private final long endingAtAfter;
    private final long endingAtBefore;
    private final String clientId;

    SubscriptionCriteria(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.apis = builder.apis;
        this.plans = builder.plans;
        this.applications = builder.applications;
        this.statuses = builder.status;
        this.clientId = builder.clientId;
        this.endingAtAfter = builder.endingAtAfter;
        this.endingAtBefore = builder.endingAtBefore;
    }

    public Collection<String> getApis() {
        return this.apis;
    }

    public Collection<String> getPlans() {
        return this.plans;
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    public Collection<Subscription.Status> getStatuses() {
        return this.statuses;
    }

    public Collection<String> getApplications() {
        return this.applications;
    }

    public String getClientId() {
        return this.clientId;
    }

    public long getEndingAtAfter() {
        return this.endingAtAfter;
    }

    public long getEndingAtBefore() {
        return this.endingAtBefore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionCriteria that = (SubscriptionCriteria)o;
        if (this.from != that.from) {
            return false;
        }
        if (this.to != that.to) {
            return false;
        }
        if (this.apis != null ? !this.apis.equals(that.apis) : that.apis != null) {
            return false;
        }
        if (this.plans != null ? !this.plans.equals(that.plans) : that.plans != null) {
            return false;
        }
        if (this.statuses != null ? !this.statuses.equals(that.statuses) : that.statuses != null) {
            return false;
        }
        if (this.endingAtAfter != that.endingAtAfter) {
            return false;
        }
        if (this.endingAtBefore != that.endingAtBefore) {
            return false;
        }
        return this.applications != null ? this.applications.equals(that.applications) : that.applications == null;
    }

    public int hashCode() {
        int result = this.apis != null ? this.apis.hashCode() : 0;
        result = 31 * result + (this.plans != null ? this.plans.hashCode() : 0);
        result = 31 * result + (this.statuses != null ? this.statuses.hashCode() : 0);
        result = 31 * result + (this.applications != null ? this.applications.hashCode() : 0);
        result = 31 * result + (int)(this.from ^ this.from >>> 32);
        result = 31 * result + (int)(this.to ^ this.to >>> 32);
        result = 31 * result + (int)(this.endingAtAfter ^ this.endingAtAfter >>> 32);
        result = 31 * result + (int)(this.endingAtBefore ^ this.endingAtBefore >>> 32);
        return result;
    }

    public static class Builder {
        private Collection<String> apis;
        private Collection<String> applications;
        private Collection<String> plans;
        private Collection<Subscription.Status> status;
        private String clientId;
        private long from;
        private long to;
        private long endingAtAfter;
        private long endingAtBefore;

        public Builder from(long from) {
            this.from = from;
            return this;
        }

        public Builder to(long to) {
            this.to = to;
            return this;
        }

        public Builder apis(Collection<String> apis) {
            this.apis = apis;
            return this;
        }

        public Builder applications(Collection<String> applications) {
            this.applications = applications;
            return this;
        }

        public Builder plans(Collection<String> plans) {
            this.plans = plans;
            return this;
        }

        public Builder status(Subscription.Status status) {
            this.status = Collections.singleton(status);
            return this;
        }

        public Builder statuses(Collection<Subscription.Status> status) {
            this.status = status;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder endingAtAfter(long endingAtAfter) {
            this.endingAtAfter = endingAtAfter;
            return this;
        }

        public Builder endingAtBefore(long endingAtBefore) {
            this.endingAtBefore = endingAtBefore;
            return this;
        }

        public SubscriptionCriteria build() {
            return new SubscriptionCriteria(this);
        }
    }
}

