/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api.search;

public class CommandCriteria {
    private String to;
    private String[] tags;
    private boolean notExpired;
    private String notFrom;
    private String notAckBy;
    private String environmentId;

    private CommandCriteria(Builder builder) {
        this.to = builder.to;
        this.tags = builder.tags;
        this.notExpired = builder.notDeleted;
        this.notFrom = builder.notFrom;
        this.notAckBy = builder.notAckBy;
        this.environmentId = builder.environmentId;
    }

    public String getTo() {
        return this.to;
    }

    public String[] getTags() {
        return this.tags;
    }

    public boolean isNotExpired() {
        return this.notExpired;
    }

    public String getNotFrom() {
        return this.notFrom;
    }

    public String getNotAckBy() {
        return this.notAckBy;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public String toString() {
        return "criteria {to: " + this.to + "tags: " + this.tags + "notExpired: " + this.notExpired + "notFrom: " + this.notFrom + "notAckBy:" + this.notAckBy + "environmentId:" + this.environmentId + "}";
    }

    public static class Builder {
        private String to;
        private String[] tags;
        private boolean notDeleted;
        private String notFrom;
        private String notAckBy;
        private String environmentId;

        public CommandCriteria build() {
            return new CommandCriteria(this);
        }

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder tags(String ... tags) {
            this.tags = tags;
            return this;
        }

        public Builder notDeleted() {
            this.notDeleted = true;
            return this;
        }

        public Builder notFrom(String from) {
            this.notFrom = from;
            return this;
        }

        public Builder notAckBy(String by) {
            this.notAckBy = by;
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }
    }
}

