/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api.search;

import io.gravitee.repository.management.model.ApplicationStatus;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ApplicationCriteria {
    private List<String> ids;
    private String name;
    private String environmentId;
    private ApplicationStatus status;

    ApplicationCriteria(Builder builder) {
        this.ids = builder.ids;
        this.name = builder.name;
        this.environmentId = builder.environmentId;
        this.status = builder.status;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public ApplicationStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationCriteria)) {
            return false;
        }
        ApplicationCriteria that = (ApplicationCriteria)o;
        return Objects.equals(this.ids, that.ids) && Objects.equals(this.name, that.name) && Objects.equals(this.environmentId, that.environmentId) && Objects.equals((Object)this.status, (Object)that.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ids, this.name, this.environmentId, this.status});
    }

    public static class Builder {
        private List<String> ids;
        private String name;
        private String environmentId;
        private ApplicationStatus status;

        public Builder ids(String ... id) {
            this.ids = Arrays.asList(id);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder status(ApplicationStatus status) {
            this.status = status;
            return this;
        }

        public ApplicationCriteria build() {
            return new ApplicationCriteria(this);
        }
    }
}

