/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api.search;

import io.gravitee.repository.management.model.EventType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EventCriteria {
    private Collection<EventType> types;
    private Map<String, Object> properties;
    private long from;
    private long to;
    private List<String> environments;
    private boolean strictMode;

    EventCriteria(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.types = new HashSet<EventType>(builder.types);
        this.properties = new HashMap<String, Object>(builder.properties);
        this.environments = builder.environments;
        this.strictMode = builder.strictMode;
    }

    public Collection<EventType> getTypes() {
        return this.types;
    }

    public void setTypes(Collection<EventType> types) {
        this.types = types;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public long getFrom() {
        return this.from;
    }

    public void setFrom(long from) {
        this.from = from;
    }

    public long getTo() {
        return this.to;
    }

    public void setTo(long to) {
        this.to = to;
    }

    public List<String> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<String> environments) {
        this.environments = environments;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventCriteria that = (EventCriteria)o;
        if (this.from != that.from) {
            return false;
        }
        if (this.to != that.to) {
            return false;
        }
        if (this.types != null ? !this.types.equals(that.types) : that.types != null) {
            return false;
        }
        if (this.environments != null ? !this.environments.equals(that.environments) : that.environments != null) {
            return false;
        }
        if (this.strictMode != that.strictMode) {
            return false;
        }
        return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
    }

    public int hashCode() {
        return Objects.hash(this.types, this.properties, this.environments, this.from, this.to, this.strictMode);
    }

    public static class Builder {
        private Map<String, Object> properties = new HashMap<String, Object>();
        private Collection<EventType> types = new ArrayList<EventType>();
        private long from;
        private long to;
        private List<String> environments;
        private boolean strictMode;

        public Builder from(long from) {
            this.from = from;
            return this;
        }

        public Builder to(long to) {
            this.to = to;
            return this;
        }

        public Builder types(EventType ... types) {
            for (int i = 0; i < types.length; ++i) {
                this.types.add(types[i]);
            }
            return this;
        }

        public Builder property(String key, Object value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder environments(List<String> environments) {
            this.environments = environments;
            return this;
        }

        public Builder strictMode(boolean strictMode) {
            this.strictMode = strictMode;
            return this;
        }

        public EventCriteria build() {
            return new EventCriteria(this);
        }
    }
}

