/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.model;

import io.gravitee.repository.management.model.Audit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ApiKey
implements Serializable {
    private String id;
    private String key;
    private List<String> subscriptions = new ArrayList<String>();
    private String subscription;
    private String plan;
    private String api;
    private String application;
    private Date expireAt;
    private Date createdAt;
    private Date updatedAt;
    private boolean revoked;
    private boolean paused;
    private Date revokedAt;
    private Integer daysToExpirationOnLastNotification;

    public ApiKey() {
    }

    public ApiKey(ApiKey cloned) {
        this.id = cloned.id;
        this.key = cloned.key;
        this.subscriptions = cloned.subscriptions;
        this.application = cloned.application;
        this.plan = cloned.plan;
        this.expireAt = cloned.expireAt;
        this.createdAt = cloned.createdAt;
        this.updatedAt = cloned.updatedAt;
        this.revoked = cloned.revoked;
        this.revokedAt = cloned.revokedAt;
        this.paused = cloned.paused;
        this.daysToExpirationOnLastNotification = cloned.daysToExpirationOnLastNotification;
        this.api = cloned.api;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public void setRevoked(boolean revoked) {
        this.revoked = revoked;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public Date getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(Date expireAt) {
        this.expireAt = expireAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getRevokedAt() {
        return this.revokedAt;
    }

    public void setRevokedAt(Date revokedAt) {
        this.revokedAt = revokedAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public List<String> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(List<String> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public Integer getDaysToExpirationOnLastNotification() {
        return this.daysToExpirationOnLastNotification;
    }

    public void setDaysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public String getSubscription() {
        return this.subscription;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public String getPlan() {
        return this.plan;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public void setPlan(String plan) {
        this.plan = plan;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public String getApi() {
        return this.api;
    }

    @Deprecated(since="3.17.0", forRemoval=true)
    public void setApi(String api) {
        this.api = api;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiKey apiKey = (ApiKey)o;
        return Objects.equals(this.id, apiKey.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static enum AuditEvent implements Audit.ApiAuditEvent
    {
        APIKEY_CREATED,
        APIKEY_RENEWED,
        APIKEY_REVOKED,
        APIKEY_EXPIRED,
        APIKEY_REACTIVATED;

    }
}

