/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api.search;

import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.management.model.Subscription;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;

public class SubscriptionCriteria {
    private final Collection<String> ids;
    private final Collection<String> apis;
    private final Collection<String> plans;
    private final Collection<String> statuses;
    private final Collection<String> applications;
    private final Collection<String> planSecurityTypes;
    private final long from;
    private final long to;
    private final long endingAtAfter;
    private final long endingAtBefore;
    private final String clientId;

    SubscriptionCriteria(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.ids = builder.ids;
        this.apis = builder.apis;
        this.plans = builder.plans;
        this.applications = builder.applications;
        this.statuses = builder.status;
        this.clientId = builder.clientId;
        this.endingAtAfter = builder.endingAtAfter;
        this.endingAtBefore = builder.endingAtBefore;
        this.planSecurityTypes = builder.planSecurityTypes;
    }

    public Collection<String> getIds() {
        return this.ids;
    }

    public Collection<String> getApis() {
        return this.apis;
    }

    public Collection<String> getPlans() {
        return this.plans;
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    public Collection<String> getStatuses() {
        return this.statuses;
    }

    public Collection<String> getApplications() {
        return this.applications;
    }

    public String getClientId() {
        return this.clientId;
    }

    public long getEndingAtAfter() {
        return this.endingAtAfter;
    }

    public long getEndingAtBefore() {
        return this.endingAtBefore;
    }

    public Collection<String> getPlanSecurityTypes() {
        return this.planSecurityTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionCriteria that = (SubscriptionCriteria)o;
        return this.from == that.from && this.to == that.to && this.endingAtAfter == that.endingAtAfter && this.endingAtBefore == that.endingAtBefore && Objects.equals(this.ids, that.ids) && Objects.equals(this.apis, that.apis) && Objects.equals(this.plans, that.plans) && Objects.equals(this.statuses, that.statuses) && Objects.equals(this.applications, that.applications) && Objects.equals(this.planSecurityTypes, that.planSecurityTypes);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.apis, this.plans, this.statuses, this.applications, this.from, this.to, this.endingAtAfter, this.endingAtBefore, this.planSecurityTypes);
    }

    public static class Builder {
        private Collection<String> ids;
        private Collection<String> apis;
        private Collection<String> applications;
        private Collection<String> plans;
        private Collection<String> status;
        private String clientId;
        private long from;
        private long to;
        private long endingAtAfter;
        private long endingAtBefore;
        private Collection<String> planSecurityTypes;

        public Builder from(long from) {
            this.from = from;
            return this;
        }

        public Builder to(long to) {
            this.to = to;
            return this;
        }

        public Builder ids(Collection<String> ids) {
            this.ids = ids;
            return this;
        }

        public Builder apis(Collection<String> apis) {
            this.apis = apis;
            return this;
        }

        public Builder applications(Collection<String> applications) {
            this.applications = applications;
            return this;
        }

        public Builder plans(Collection<String> plans) {
            this.plans = plans;
            return this;
        }

        public Builder status(Subscription.Status status) {
            this.status = Collections.singleton(status.name());
            return this;
        }

        public Builder statuses(Collection<Subscription.Status> status) {
            this.status = status.stream().map(Enum::name).collect(Collectors.toList());
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder endingAtAfter(long endingAtAfter) {
            this.endingAtAfter = endingAtAfter;
            return this;
        }

        public Builder endingAtBefore(long endingAtBefore) {
            this.endingAtBefore = endingAtBefore;
            return this;
        }

        public Builder planSecurityTypes(Collection<Plan.PlanSecurityType> planSecurityType) {
            this.planSecurityTypes = planSecurityType.stream().map(Enum::name).collect(Collectors.toList());
            return this;
        }

        public SubscriptionCriteria build() {
            return new SubscriptionCriteria(this);
        }
    }
}

