/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api.search;

import java.util.Collection;

public class ApiKeyCriteria {
    private final Collection<String> plans;
    private final long from;
    private final long to;
    private final boolean includeRevoked;
    private final long expireAfter;
    private final long expireBefore;

    ApiKeyCriteria(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.plans = builder.plans;
        this.includeRevoked = builder.includeRevoked;
        this.expireAfter = builder.expireAfter;
        this.expireBefore = builder.expireBefore;
    }

    public Collection<String> getPlans() {
        return this.plans;
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    public boolean isIncludeRevoked() {
        return this.includeRevoked;
    }

    public long getExpireAfter() {
        return this.expireAfter;
    }

    public long getExpireBefore() {
        return this.expireBefore;
    }

    public static class Builder {
        private Collection<String> plans;
        private long from;
        private long to;
        private boolean includeRevoked;
        private long expireAfter;
        private long expireBefore;

        public Builder from(long from) {
            this.from = from;
            return this;
        }

        public Builder to(long to) {
            this.to = to;
            return this;
        }

        public Builder plans(Collection<String> plans) {
            this.plans = plans;
            return this;
        }

        public Builder includeRevoked(boolean include) {
            this.includeRevoked = include;
            return this;
        }

        public Builder expireAfter(long expireAtAfter) {
            this.expireAfter = expireAtAfter;
            return this;
        }

        public Builder expireBefore(long expireAtBefore) {
            this.expireBefore = expireAtBefore;
            return this;
        }

        public ApiKeyCriteria build() {
            return new ApiKeyCriteria(this);
        }
    }
}

