/*
 * Copyright © 2015 The Gravitee team (http://gravitee.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gravitee.plugin.entrypoint;

import io.gravitee.gateway.reactive.api.connector.entrypoint.EntrypointConnectorFactory;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import java.io.IOException;

/**
 * @author Guillaume LAMIRAND (guillaume.lamirand at graviteesource.com)
 * @author GraviteeSource Team
 */
public interface EntrypointConnectorPluginManager extends ConfigurablePluginManager<EntrypointConnectorPlugin<?, ?>> {
    /**
     * @return the factory <code>Class</code> according to the given plugin id
     */
    <T extends EntrypointConnectorFactory<?>> T getFactoryById(final String entrypointPluginId);

    <T extends EntrypointConnectorFactory<?>> T getFactoryById(final String entrypointPluginId, final boolean includeNotDeployed);

    String getSubscriptionSchema(String pluginId) throws IOException;

    String getSubscriptionSchema(String pluginId, boolean includeNotDeployed) throws IOException;
}
