/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.mock;

import io.gravitee.gateway.jupiter.api.ConnectorMode;
import io.gravitee.gateway.jupiter.api.connector.endpoint.async.EndpointAsyncConnector;
import io.gravitee.gateway.jupiter.api.context.ExecutionContext;
import io.gravitee.gateway.jupiter.api.message.DefaultMessage;
import io.gravitee.gateway.jupiter.api.message.Message;
import io.gravitee.plugin.endpoint.mock.configuration.MockEndpointConnectorConfiguration;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockEndpointConnector
implements EndpointAsyncConnector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MockEndpointConnector.class);
    static final Set<ConnectorMode> SUPPORTED_MODES = Set.of(ConnectorMode.PUBLISH, ConnectorMode.SUBSCRIBE);
    protected final MockEndpointConnectorConfiguration configuration;

    public Set<ConnectorMode> supportedModes() {
        return SUPPORTED_MODES;
    }

    public Completable connect(ExecutionContext ctx) {
        return Completable.defer(() -> ctx.request().messages().doOnNext(message -> log.info("Received message:\n" + message.content().toString())).ignoreElements().andThen((CompletableSource)Completable.fromRunnable(() -> ctx.response().messages(this.generateMessageFlow()))));
    }

    private Flowable<Message> generateMessageFlow() {
        Flowable messageFlow = Flowable.interval((long)this.configuration.getMessageInterval(), (TimeUnit)TimeUnit.MILLISECONDS).map(value -> this.configuration.getMessageContent() + " " + value).map(DefaultMessage::new);
        if (this.configuration.getMessageCount() != null) {
            return messageFlow.limit(this.configuration.getMessageCount().longValue());
        }
        return messageFlow;
    }

    @Generated
    public MockEndpointConnector(MockEndpointConnectorConfiguration configuration) {
        this.configuration = configuration;
    }
}

