/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.http.proxy.client;

import io.gravitee.common.util.MultiValueMap;
import io.gravitee.gateway.jupiter.http.vertx.client.VertxHttpClient;
import io.gravitee.node.api.configuration.Configuration;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorConfiguration;
import io.vertx.core.http.RequestOptions;
import io.vertx.rxjava3.core.Vertx;
import io.vertx.rxjava3.core.http.HttpClient;
import java.util.StringJoiner;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxHttpClientHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VertxHttpClientHelper.class);
    public static final String URI_PARAM_SEPARATOR = "&";
    public static final char URI_PARAM_SEPARATOR_CHAR = '&';
    public static final char URI_PARAM_VALUE_SEPARATOR_CHAR = '=';
    public static final char URI_QUERY_DELIMITER_CHAR = '?';
    public static final CharSequence URI_QUERY_DELIMITER_CHAR_SEQUENCE = "?";

    public static HttpClient buildHttpClient(Vertx vertx, Configuration nodeConfiguration, HttpProxyEndpointConnectorConfiguration configuration, String defaultTarget) {
        return VertxHttpClient.builder().vertx(vertx).nodeConfiguration(nodeConfiguration).defaultTarget(defaultTarget).httpOptions(configuration.getHttpOptions()).sslOptions(configuration.getSslOptions()).proxyOptions(configuration.getProxyOptions()).build().createHttpClient();
    }

    public static RequestOptions configureAbsoluteUri(RequestOptions requestOptions, String uri, MultiValueMap<String, String> parameters) {
        return requestOptions.setURI(VertxHttpClientHelper.buildFinalUri(uri, parameters));
    }

    private static String buildFinalUri(String targetUri, MultiValueMap<String, String> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            StringJoiner parametersAsString = new StringJoiner(URI_PARAM_SEPARATOR);
            parameters.forEach((paramName, paramValues) -> {
                if (paramValues != null) {
                    for (String paramValue : paramValues) {
                        if (paramValue == null) {
                            parametersAsString.add((CharSequence)paramName);
                            continue;
                        }
                        parametersAsString.add(paramName + "=" + paramValue);
                    }
                }
            });
            if (targetUri.contains(URI_QUERY_DELIMITER_CHAR_SEQUENCE)) {
                return targetUri + URI_PARAM_SEPARATOR + parametersAsString;
            }
            return targetUri + "?" + parametersAsString;
        }
        return targetUri;
    }

    @Generated
    private VertxHttpClientHelper() {
    }
}

