/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.http.proxy;

import io.gravitee.common.http.HttpHeader;
import io.gravitee.definition.model.v4.http.HttpProxyOptions;
import io.gravitee.el.TemplateEngine;
import io.gravitee.gateway.jupiter.api.ConnectorMode;
import io.gravitee.gateway.jupiter.api.connector.ConnectorHelper;
import io.gravitee.gateway.jupiter.api.connector.endpoint.sync.EndpointSyncConnectorFactory;
import io.gravitee.gateway.jupiter.api.context.DeploymentContext;
import io.gravitee.plugin.endpoint.http.proxy.HttpProxyEndpointConnector;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorConfiguration;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyEndpointConnectorFactory
implements EndpointSyncConnectorFactory<HttpProxyEndpointConnector> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpProxyEndpointConnectorFactory.class);
    private final ConnectorHelper connectorFactoryHelper;

    public Set<ConnectorMode> supportedModes() {
        return HttpProxyEndpointConnector.SUPPORTED_MODES;
    }

    public HttpProxyEndpointConnector createConnector(DeploymentContext deploymentContext, String configuration) {
        try {
            return new HttpProxyEndpointConnector(this.eval(deploymentContext, (HttpProxyEndpointConnectorConfiguration)this.connectorFactoryHelper.readConfiguration(HttpProxyEndpointConnectorConfiguration.class, configuration)));
        }
        catch (Exception e) {
            log.error("Can't create connector cause no valid configuration", (Throwable)e);
            return null;
        }
    }

    private HttpProxyEndpointConnectorConfiguration eval(DeploymentContext deploymentContext, HttpProxyEndpointConnectorConfiguration configuration) {
        TemplateEngine templateEngine = deploymentContext.getTemplateEngine();
        HttpProxyOptions proxyOptions = configuration.getProxyOptions();
        List<HttpHeader> headers = configuration.getHeaders();
        configuration.setTarget(this.eval(templateEngine, configuration.getTarget()));
        if (proxyOptions != null) {
            proxyOptions.setHost(this.eval(templateEngine, proxyOptions.getHost()));
            proxyOptions.setUsername(this.eval(templateEngine, proxyOptions.getUsername()));
            proxyOptions.setPassword(this.eval(templateEngine, proxyOptions.getPassword()));
        }
        if (headers != null && !headers.isEmpty()) {
            headers.forEach(httpHeader -> httpHeader.setValue(this.eval(templateEngine, httpHeader.getValue())));
        }
        return configuration;
    }

    private String eval(TemplateEngine templateEngine, String value) {
        if (value != null && !value.isEmpty()) {
            return templateEngine.convert(value);
        }
        return value;
    }

    @Generated
    public HttpProxyEndpointConnectorFactory(ConnectorHelper connectorFactoryHelper) {
        this.connectorFactoryHelper = connectorFactoryHelper;
    }
}

