/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.internal;

import io.gravitee.plugin.core.api.AbstractSimplePluginHandler;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.endpoint.EndpointConnectorPlugin;
import io.gravitee.plugin.endpoint.internal.DefaultEndpointConnectorPlugin;
import io.gravitee.plugin.endpoint.internal.DefaultEndpointConnectorPluginManager;
import io.gravitee.plugin.endpoint.internal.EndpointConnectorConfigurationClassFinder;
import java.io.IOException;
import java.net.URLClassLoader;
import org.springframework.beans.factory.annotation.Autowired;

public class EndpointConnectorPluginHandler
extends AbstractSimplePluginHandler<EndpointConnectorPlugin<?, ?>> {
    @Autowired
    private DefaultEndpointConnectorPluginManager endpointPluginManager;

    public boolean canHandle(Plugin plugin) {
        return "endpoint-connector".equalsIgnoreCase(plugin.type());
    }

    protected String type() {
        return "endpoint-connector";
    }

    protected EndpointConnectorPlugin<?, ?> create(Plugin plugin, Class<?> pluginClass) {
        Class configurationClass = new EndpointConnectorConfigurationClassFinder().lookupFirst(pluginClass);
        return new DefaultEndpointConnectorPlugin(plugin, pluginClass, configurationClass);
    }

    protected void register(EndpointConnectorPlugin<?, ?> endpointConnectorPlugin) {
        this.endpointPluginManager.register(endpointConnectorPlugin);
        ClassLoader policyClassLoader = endpointConnectorPlugin.connectorFactory().getClassLoader();
        if (policyClassLoader instanceof URLClassLoader) {
            URLClassLoader classLoader = (URLClassLoader)policyClassLoader;
            try {
                classLoader.close();
            }
            catch (IOException e) {
                this.logger.error("Unexpected exception while trying to release the policy classloader");
            }
        }
    }

    protected ClassLoader getClassLoader(Plugin plugin) {
        return new URLClassLoader(plugin.dependencies(), ((Object)((Object)this)).getClass().getClassLoader());
    }
}

