/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.plugin.apiservice.dynamicproperties.http;

import com.google.common.annotations.VisibleForTesting;
import io.gravitee.apim.plugin.apiservice.dynamicproperties.http.HttpDynamicPropertiesServiceConfiguration;
import io.gravitee.apim.plugin.apiservice.dynamicproperties.http.http.HttpClientFactory;
import io.gravitee.apim.plugin.apiservice.dynamicproperties.http.jolt.JoltMapper;
import io.gravitee.apim.rest.api.common.apiservices.ManagementApiService;
import io.gravitee.apim.rest.api.common.apiservices.ManagementDeploymentContext;
import io.gravitee.apim.rest.api.common.apiservices.events.DynamicPropertiesEvent;
import io.gravitee.apim.rest.api.common.apiservices.events.ManagementApiServiceEvent;
import io.gravitee.common.cron.CronTrigger;
import io.gravitee.common.event.EventManager;
import io.gravitee.common.http.HttpHeader;
import io.gravitee.common.util.URIUtils;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.property.Property;
import io.gravitee.definition.model.v4.service.Service;
import io.gravitee.gateway.reactive.api.exception.PluginConfigurationException;
import io.gravitee.gateway.reactive.api.helper.PluginConfigurationHelper;
import io.gravitee.node.api.cluster.ClusterManager;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.rxjava3.core.buffer.Buffer;
import io.vertx.rxjava3.core.http.HttpClient;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDynamicPropertiesService
implements ManagementApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpDynamicPropertiesService.class);
    public static final String HTTP_DYNAMIC_PROPERTIES_TYPE = "http-dynamic-properties";
    private static int LOG_ERROR_COUNT = 10;
    private final ManagementDeploymentContext deploymentContext;
    private final PluginConfigurationHelper pluginConfigurationHelper;
    private final ClusterManager clusterManager;
    private final EventManager eventManager;
    private HttpDynamicPropertiesServiceConfiguration configuration;
    private Api api;
    private HttpClient httpClient;
    private JoltMapper joltMapper;
    @VisibleForTesting
    final AtomicReference<Disposable> scheduledJob = new AtomicReference();
    @VisibleForTesting
    CronTrigger cronTrigger;

    public HttpDynamicPropertiesService(ManagementDeploymentContext deploymentContext) {
        this.deploymentContext = deploymentContext;
        this.api = (Api)deploymentContext.getComponent(Api.class);
        this.clusterManager = (ClusterManager)deploymentContext.getComponent(ClusterManager.class);
        this.eventManager = (EventManager)deploymentContext.getComponent(EventManager.class);
        this.pluginConfigurationHelper = (PluginConfigurationHelper)deploymentContext.getComponent(PluginConfigurationHelper.class);
    }

    public String id() {
        return HTTP_DYNAMIC_PROPERTIES_TYPE;
    }

    public String kind() {
        return "dynamic-properties";
    }

    public Completable start() {
        log.debug("Starting dynamic properties service for Api: {}", (Object)this.api.getId());
        this.disposeExistingJob();
        try {
            this.configuration = (HttpDynamicPropertiesServiceConfiguration)this.pluginConfigurationHelper.readConfiguration(HttpDynamicPropertiesServiceConfiguration.class, this.api.getServices().getDynamicProperty().getConfiguration());
        }
        catch (PluginConfigurationException e) {
            return Completable.error((Throwable)new IllegalArgumentException("Unable to start http-dynamic-properties service for api: [" + this.api.getId() + "]"));
        }
        this.httpClient = HttpClientFactory.createClient(this.deploymentContext, this.configuration);
        this.joltMapper = new JoltMapper(this.configuration.getTransformation());
        this.scheduledJob.set(this.scheduleInBackground());
        return Completable.complete();
    }

    public Completable stop() {
        log.debug("Stopping dynamic properties service for api {}", (Object)this.api.getId());
        this.disposeExistingJob();
        return this.httpClient.close();
    }

    public Completable update(Api updatedApi) {
        log.debug("Restarting dynamic properties service for api: {}", (Object)updatedApi.getId());
        Disposable currentJob = this.scheduledJob.get();
        Service currentDynamicPropertiesService = this.api.getServices().getDynamicProperty().toBuilder().build();
        Service updatedDynamicPropertiesService = updatedApi.getServices().getDynamicProperty().toBuilder().build();
        this.api = updatedApi;
        if ((currentJob == null || currentJob.isDisposed()) && updatedDynamicPropertiesService.isEnabled()) {
            return this.start();
        }
        if (currentDynamicPropertiesService != null) {
            if (!updatedDynamicPropertiesService.isEnabled()) {
                return this.stop();
            }
            if (!Objects.equals(currentDynamicPropertiesService, updatedDynamicPropertiesService)) {
                return this.stop().andThen((CompletableSource)this.start());
            }
        }
        return Completable.complete();
    }

    private Disposable scheduleInBackground() {
        this.cronTrigger = new CronTrigger(this.configuration.getSchedule());
        AtomicLong errorCount = new AtomicLong(0L);
        return Observable.defer(() -> Observable.timer((long)this.cronTrigger.nextExecutionIn(), (TimeUnit)TimeUnit.MILLISECONDS)).observeOn(Schedulers.computation()).filter(aLong -> this.clusterManager.self().primary()).switchMapCompletable(aLong -> this.fetchProperties()).onErrorResumeNext(throwable -> this.logOnError(errorCount, (Throwable)throwable)).repeat().subscribe(() -> {}, throwable -> log.error("Unable to run Dynamic Properties for Api: {}", (Object)this.api.getId()));
    }

    private Completable fetchProperties() {
        if (!URIUtils.isAbsolute((String)this.configuration.getUrl())) {
            return Completable.error((Throwable)new IllegalArgumentException("Target url [" + this.configuration.getUrl() + "] must be absolute to perform dynamic properties fetching against."));
        }
        RequestOptions requestOptions = new RequestOptions();
        HeadersMultiMap headers = new HeadersMultiMap();
        this.configuration.getHeaders().forEach(arg_0 -> HttpDynamicPropertiesService.lambda$fetchProperties$6((MultiMap)headers, arg_0));
        requestOptions.setHeaders((MultiMap)headers);
        URL target = HttpClientFactory.buildUrl(this.configuration.getUrl());
        boolean isSsl = HttpClientFactory.isSecureProtocol(target.getProtocol());
        requestOptions.setMethod(HttpMethod.valueOf((String)this.configuration.getMethod().name())).setURI((String)(target.getQuery() == null ? target.getPath() : target.getPath() + "?" + target.getQuery())).setPort(Integer.valueOf(HttpClientFactory.getPort(target, isSsl))).setSsl(Boolean.valueOf(isSsl)).setHeaders((MultiMap)headers).setHost(target.getHost());
        return this.httpClient.rxRequest(requestOptions).observeOn(Schedulers.io()).flatMap(request -> this.configuration.getBody() != null ? request.rxSend(this.configuration.getBody()) : request.rxSend()).flatMapCompletable(response -> {
            if (response.statusCode() != 200) {
                return response.toFlowable().ignoreElements();
            }
            return response.body().flatMapCompletable(this::evaluateAndDispatchProperties);
        });
    }

    private Completable logOnError(AtomicLong errorCount, Throwable throwable) {
        if (errorCount.incrementAndGet() == 1L) {
            log.warn("Unable to run dynamic properties for api [{}] on URL [{}].", new Object[]{this.api.getId(), this.configuration.getUrl(), throwable});
        } else if (errorCount.get() % (long)LOG_ERROR_COUNT == 0L) {
            log.warn("Unable to run dynamic properties for api [{}] on URL [{}] (times: {}, see previous log report for details).", new Object[]{this.api.getId(), this.configuration.getUrl(), errorCount.get()});
        }
        return Completable.complete();
    }

    private Completable evaluateAndDispatchProperties(Buffer bodyBuffer) {
        return Completable.fromRunnable(() -> {
            List<Property> properties = this.joltMapper.map(bodyBuffer.toString());
            this.eventManager.publishEvent((Enum)ManagementApiServiceEvent.DYNAMIC_PROPERTY_UPDATE, (Object)new DynamicPropertiesEvent(this.api.getId(), this.id(), properties));
        }).subscribeOn(Schedulers.io());
    }

    private void disposeExistingJob() {
        Optional.ofNullable(this.scheduledJob.get()).ifPresent(Disposable::dispose);
    }

    @VisibleForTesting
    static void setLogErrorCount(int logErrorCount) {
        LOG_ERROR_COUNT = logErrorCount;
    }

    @Generated
    public ManagementDeploymentContext getDeploymentContext() {
        return this.deploymentContext;
    }

    @Generated
    public PluginConfigurationHelper getPluginConfigurationHelper() {
        return this.pluginConfigurationHelper;
    }

    @Generated
    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    @Generated
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Generated
    public HttpDynamicPropertiesServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Api getApi() {
        return this.api;
    }

    @Generated
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public JoltMapper getJoltMapper() {
        return this.joltMapper;
    }

    @Generated
    public AtomicReference<Disposable> getScheduledJob() {
        return this.scheduledJob;
    }

    @Generated
    public CronTrigger getCronTrigger() {
        return this.cronTrigger;
    }

    private static /* synthetic */ void lambda$fetchProperties$6(MultiMap headers, HttpHeader header) {
        headers.add(header.getName(), header.getValue());
    }
}

