/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.synchronizer.subscription;

import io.gravitee.gateway.api.service.Subscription;
import io.gravitee.gateway.services.sync.process.common.deployer.DeployerFactory;
import io.gravitee.gateway.services.sync.process.common.deployer.SubscriptionDeployer;
import io.gravitee.gateway.services.sync.process.common.model.SyncAction;
import io.gravitee.gateway.services.sync.process.repository.RepositorySynchronizer;
import io.gravitee.gateway.services.sync.process.repository.fetcher.SubscriptionFetcher;
import io.gravitee.gateway.services.sync.process.repository.mapper.SubscriptionMapper;
import io.gravitee.gateway.services.sync.process.repository.service.PlanService;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.subscription.SingleSubscriptionDeployable;
import io.gravitee.repository.management.model.Subscription;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionSynchronizer
implements RepositorySynchronizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubscriptionSynchronizer.class);
    private final SubscriptionFetcher subscriptionFetcher;
    private final SubscriptionMapper subscriptionMapper;
    private final DeployerFactory deployerFactory;
    private final PlanService planCache;
    private final ThreadPoolExecutor syncFetcherExecutor;
    private final ThreadPoolExecutor syncDeployerExecutor;

    @Override
    public Completable synchronize(Long from, Long to, List<String> environments) {
        if (from == -1L) {
            return Completable.complete();
        }
        AtomicLong launchTime = new AtomicLong();
        return this.subscriptionFetcher.fetchLatest(from, to).subscribeOn(Schedulers.from((Executor)this.syncFetcherExecutor)).flatMap(subscriptions -> Flowable.just((Object)subscriptions).flatMapIterable(s -> s).filter(subscription -> this.planCache.isDeployed(subscription.getApi(), subscription.getPlan())).flatMapMaybe(subscription -> Maybe.fromCallable(() -> this.subscriptionMapper.to((io.gravitee.repository.management.model.Subscription)subscription))).map(subscription -> SingleSubscriptionDeployable.builder().subscription((Subscription)subscription).syncAction(subscription.getStatus().equals(Subscription.Status.ACCEPTED.name()) ? SyncAction.DEPLOY : SyncAction.UNDEPLOY).build())).compose(upstream -> {
            SubscriptionDeployer subscriptionDeployer = this.deployerFactory.createSubscriptionDeployer();
            return upstream.parallel(this.syncDeployerExecutor.getMaximumPoolSize()).runOn(Schedulers.from((Executor)this.syncDeployerExecutor)).flatMap(deployable -> {
                if (deployable.syncAction() == SyncAction.DEPLOY) {
                    return this.deploy(subscriptionDeployer, (SingleSubscriptionDeployable)deployable);
                }
                if (deployable.syncAction() == SyncAction.UNDEPLOY) {
                    return this.undeploy(subscriptionDeployer, (SingleSubscriptionDeployable)deployable);
                }
                return Flowable.empty();
            }).sequential();
        }).count().doOnSubscribe(disposable -> launchTime.set(Instant.now().toEpochMilli())).doOnSuccess(count -> log.debug("Subscriptions of {} apis refreshed in {}ms", count, (Object)(System.currentTimeMillis() - launchTime.get()))).ignoreElement();
    }

    private Flowable<SingleSubscriptionDeployable> deploy(SubscriptionDeployer subscriptionDeployer, SingleSubscriptionDeployable deployable) {
        return subscriptionDeployer.deploy(deployable).andThen((CompletableSource)subscriptionDeployer.doAfterDeployment(deployable)).andThen((Publisher)Flowable.just((Object)deployable)).onErrorResumeNext(throwable -> {
            log.error(throwable.getMessage(), throwable);
            return Flowable.empty();
        });
    }

    private Flowable<SingleSubscriptionDeployable> undeploy(SubscriptionDeployer subscriptionDeployer, SingleSubscriptionDeployable deployable) {
        return subscriptionDeployer.undeploy(deployable).andThen((CompletableSource)subscriptionDeployer.doAfterUndeployment(deployable)).andThen((Publisher)Flowable.just((Object)deployable)).onErrorResumeNext(throwable -> {
            log.error(throwable.getMessage(), throwable);
            return Flowable.empty();
        });
    }

    @Override
    public int order() {
        return 30;
    }

    @Generated
    public SubscriptionSynchronizer(SubscriptionFetcher subscriptionFetcher, SubscriptionMapper subscriptionMapper, DeployerFactory deployerFactory, PlanService planCache, ThreadPoolExecutor syncFetcherExecutor, ThreadPoolExecutor syncDeployerExecutor) {
        this.subscriptionFetcher = subscriptionFetcher;
        this.subscriptionMapper = subscriptionMapper;
        this.deployerFactory = deployerFactory;
        this.planCache = planCache;
        this.syncFetcherExecutor = syncFetcherExecutor;
        this.syncDeployerExecutor = syncDeployerExecutor;
    }
}

