/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.synchronizer.organization;

import io.gravitee.gateway.platform.organization.ReactableOrganization;
import io.gravitee.gateway.services.sync.process.common.deployer.DeployerFactory;
import io.gravitee.gateway.services.sync.process.common.deployer.OrganizationDeployer;
import io.gravitee.gateway.services.sync.process.repository.RepositorySynchronizer;
import io.gravitee.gateway.services.sync.process.repository.fetcher.LatestEventFetcher;
import io.gravitee.gateway.services.sync.process.repository.mapper.OrganizationMapper;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.organization.FlowAppender;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.organization.OrganizationDeployable;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationSynchronizer
implements RepositorySynchronizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrganizationSynchronizer.class);
    private static final Set<EventType> EVENT_TYPES = Set.of(EventType.PUBLISH_ORGANIZATION);
    private final LatestEventFetcher eventsFetcher;
    private final OrganizationMapper organizationMapper;
    private final FlowAppender flowAppender;
    private final DeployerFactory deployerFactory;
    private final ThreadPoolExecutor syncFetcherExecutor;
    private final ThreadPoolExecutor syncDeployerExecutor;

    @Override
    public Completable synchronize(Long from, Long to, List<String> environments) {
        AtomicLong launchTime = new AtomicLong();
        return this.eventsFetcher.fetchLatest(from, to, Event.EventProperties.ORGANIZATION_ID, environments, EVENT_TYPES).subscribeOn(Schedulers.from((Executor)this.syncFetcherExecutor)).rebatchRequests(this.syncFetcherExecutor.getMaximumPoolSize()).flatMap(events -> Flowable.just((Object)events).flatMapIterable(e -> e).compose(this::prepareForDeployment)).compose(upstream -> {
            OrganizationDeployer organizationDeployer = this.deployerFactory.createOrganizationDeployer();
            return upstream.parallel(this.syncDeployerExecutor.getMaximumPoolSize()).runOn(Schedulers.from((Executor)this.syncDeployerExecutor)).flatMap(deployable -> OrganizationSynchronizer.deploy(organizationDeployer, deployable)).sequential(this.eventsFetcher.bulkItems());
        }).count().doOnSubscribe(disposable -> launchTime.set(Instant.now().toEpochMilli())).doOnSuccess(count -> {
            String logMsg = String.format("%s organizations synchronized in %sms", count, System.currentTimeMillis() - launchTime.get());
            if (from == -1L) {
                log.info(logMsg);
            } else {
                log.debug(logMsg);
            }
        }).ignoreElement();
    }

    private Flowable<OrganizationDeployable> prepareForDeployment(Flowable<Event> eventsByType) {
        return eventsByType.flatMapMaybe(this.organizationMapper::to).map(organization -> OrganizationDeployable.builder().reactableOrganization((ReactableOrganization)organization).build()).map(this.flowAppender::appends);
    }

    private static Flowable<OrganizationDeployable> deploy(OrganizationDeployer dictionaryDeployer, OrganizationDeployable deployable) {
        return dictionaryDeployer.deploy(deployable).andThen((CompletableSource)dictionaryDeployer.doAfterDeployment(deployable)).andThen((Publisher)Flowable.just((Object)deployable)).onErrorResumeNext(throwable -> {
            log.error(throwable.getMessage(), throwable);
            return Flowable.empty();
        });
    }

    @Override
    public int order() {
        return 20;
    }

    @Generated
    public OrganizationSynchronizer(LatestEventFetcher eventsFetcher, OrganizationMapper organizationMapper, FlowAppender flowAppender, DeployerFactory deployerFactory, ThreadPoolExecutor syncFetcherExecutor, ThreadPoolExecutor syncDeployerExecutor) {
        this.eventsFetcher = eventsFetcher;
        this.organizationMapper = organizationMapper;
        this.flowAppender = flowAppender;
        this.deployerFactory = deployerFactory;
        this.syncFetcherExecutor = syncFetcherExecutor;
        this.syncDeployerExecutor = syncDeployerExecutor;
    }
}

