/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.synchronizer.organization;

import io.gravitee.definition.model.flow.Consumer;
import io.gravitee.definition.model.flow.ConsumerType;
import io.gravitee.gateway.env.GatewayConfiguration;
import io.gravitee.gateway.platform.organization.ReactableOrganization;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.organization.OrganizationDeployable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowAppender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowAppender.class);
    private final GatewayConfiguration gatewayConfiguration;

    public OrganizationDeployable appends(OrganizationDeployable organizationDeployable) {
        List shardingTags = this.gatewayConfiguration.shardingTags().orElse(null);
        if (shardingTags != null && !shardingTags.isEmpty()) {
            this.filterFlows(organizationDeployable.reactableOrganization());
        }
        return organizationDeployable;
    }

    private void filterFlows(ReactableOrganization reactableOrganization) {
        List filteredFlows = reactableOrganization.getFlows().stream().filter(flow -> {
            List consumers = flow.getConsumers();
            if (consumers != null && !consumers.isEmpty()) {
                Set flowTags = consumers.stream().filter(consumer -> consumer.getConsumerType().equals((Object)ConsumerType.TAG)).map(Consumer::getConsumerId).collect(Collectors.toSet());
                return this.gatewayConfiguration.hasMatchingTags(flowTags);
            }
            return true;
        }).collect(Collectors.toList());
        reactableOrganization.setFlows(filteredFlows);
    }

    @Generated
    public FlowAppender(GatewayConfiguration gatewayConfiguration) {
        this.gatewayConfiguration = gatewayConfiguration;
    }
}

