/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.synchronizer.dictionary;

import io.gravitee.gateway.dictionary.model.Dictionary;
import io.gravitee.gateway.services.sync.process.common.deployer.DeployerFactory;
import io.gravitee.gateway.services.sync.process.common.deployer.DictionaryDeployer;
import io.gravitee.gateway.services.sync.process.common.model.SyncAction;
import io.gravitee.gateway.services.sync.process.repository.RepositorySynchronizer;
import io.gravitee.gateway.services.sync.process.repository.fetcher.LatestEventFetcher;
import io.gravitee.gateway.services.sync.process.repository.mapper.DictionaryMapper;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.dictionary.DictionaryDeployable;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionarySynchronizer
implements RepositorySynchronizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DictionarySynchronizer.class);
    private static final Set<EventType> INIT_EVENT_TYPES = Set.of(EventType.PUBLISH_DICTIONARY);
    private static final Set<EventType> INCREMENTAL_EVENT_TYPES = Set.of(EventType.PUBLISH_DICTIONARY, EventType.UNPUBLISH_DICTIONARY);
    private final LatestEventFetcher eventsFetcher;
    private final DictionaryMapper dictionaryMapper;
    private final DeployerFactory deployerFactory;
    private final ThreadPoolExecutor syncFetcherExecutor;
    private final ThreadPoolExecutor syncDeployerExecutor;

    @Override
    public Completable synchronize(Long from, Long to, List<String> environments) {
        AtomicLong launchTime = new AtomicLong();
        return this.eventsFetcher.fetchLatest(from, to, Event.EventProperties.DICTIONARY_ID, environments, from == -1L ? INIT_EVENT_TYPES : INCREMENTAL_EVENT_TYPES).subscribeOn(Schedulers.from((Executor)this.syncFetcherExecutor)).rebatchRequests(this.syncFetcherExecutor.getMaximumPoolSize()).flatMap(events -> Flowable.just((Object)events).flatMapIterable(e -> e).groupBy(Event::getType).flatMap(eventsByType -> {
            if (eventsByType.getKey() == EventType.PUBLISH_DICTIONARY) {
                return this.prepareForDeployment((Flowable<Event>)eventsByType);
            }
            if (eventsByType.getKey() == EventType.UNPUBLISH_DICTIONARY) {
                return this.prepareForUndeployment((Flowable<Event>)eventsByType);
            }
            return Flowable.empty();
        })).compose(upstream -> {
            DictionaryDeployer dictionaryDeployer = this.deployerFactory.createDictionaryDeployer();
            return upstream.parallel(this.syncDeployerExecutor.getMaximumPoolSize()).runOn(Schedulers.from((Executor)this.syncDeployerExecutor)).flatMap(deployable -> {
                if (deployable.syncAction() == SyncAction.DEPLOY) {
                    return DictionarySynchronizer.deploy(dictionaryDeployer, deployable);
                }
                if (deployable.syncAction() == SyncAction.UNDEPLOY) {
                    return DictionarySynchronizer.undeploy(dictionaryDeployer, deployable);
                }
                return Flowable.empty();
            }).sequential(this.eventsFetcher.bulkItems());
        }).count().doOnSubscribe(disposable -> launchTime.set(Instant.now().toEpochMilli())).doOnSuccess(count -> {
            String logMsg = String.format("%s dictionaries synchronized in %sms", count, System.currentTimeMillis() - launchTime.get());
            if (from == -1L) {
                log.info(logMsg);
            } else {
                log.debug(logMsg);
            }
        }).ignoreElement();
    }

    private Flowable<DictionaryDeployable> prepareForDeployment(Flowable<Event> eventsByType) {
        return eventsByType.flatMapMaybe(this.dictionaryMapper::to).map(dictionary -> DictionaryDeployable.builder().id(dictionary.getId()).dictionary((Dictionary)dictionary).syncAction(SyncAction.DEPLOY).build());
    }

    private Flowable<DictionaryDeployable> prepareForUndeployment(Flowable<Event> eventsByType) {
        return eventsByType.flatMapMaybe(this.dictionaryMapper::toId).map(dictionaryId -> DictionaryDeployable.builder().id((String)dictionaryId).syncAction(SyncAction.UNDEPLOY).build());
    }

    private static Flowable<DictionaryDeployable> deploy(DictionaryDeployer dictionaryDeployer, DictionaryDeployable deployable) {
        return dictionaryDeployer.deploy(deployable).andThen((CompletableSource)dictionaryDeployer.doAfterDeployment(deployable)).andThen((Publisher)Flowable.just((Object)deployable)).onErrorResumeNext(throwable -> {
            log.error(throwable.getMessage(), throwable);
            return Flowable.empty();
        });
    }

    private static Flowable<DictionaryDeployable> undeploy(DictionaryDeployer dictionaryDeployer, DictionaryDeployable deployable) {
        return dictionaryDeployer.undeploy(deployable).andThen((CompletableSource)dictionaryDeployer.doAfterUndeployment(deployable)).andThen((Publisher)Flowable.just((Object)deployable)).onErrorResumeNext(throwable -> {
            log.error(throwable.getMessage(), throwable);
            return Flowable.empty();
        });
    }

    @Override
    public int order() {
        return 10;
    }

    @Generated
    public DictionarySynchronizer(LatestEventFetcher eventsFetcher, DictionaryMapper dictionaryMapper, DeployerFactory deployerFactory, ThreadPoolExecutor syncFetcherExecutor, ThreadPoolExecutor syncDeployerExecutor) {
        this.eventsFetcher = eventsFetcher;
        this.dictionaryMapper = dictionaryMapper;
        this.deployerFactory = deployerFactory;
        this.syncFetcherExecutor = syncFetcherExecutor;
        this.syncDeployerExecutor = syncDeployerExecutor;
    }
}

