/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.synchronizer.apikey;

import io.gravitee.gateway.api.service.ApiKey;
import io.gravitee.gateway.handlers.api.services.SubscriptionCacheService;
import io.gravitee.gateway.services.sync.process.common.deployer.ApiKeyDeployer;
import io.gravitee.gateway.services.sync.process.common.deployer.DeployerFactory;
import io.gravitee.gateway.services.sync.process.common.model.SyncAction;
import io.gravitee.gateway.services.sync.process.repository.RepositorySynchronizer;
import io.gravitee.gateway.services.sync.process.repository.fetcher.ApiKeyFetcher;
import io.gravitee.gateway.services.sync.process.repository.mapper.ApiKeyMapper;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.apikey.SingleApiKeyDeployable;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiKeySynchronizer
implements RepositorySynchronizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiKeySynchronizer.class);
    private final ApiKeyFetcher apiKeyFetcher;
    private final SubscriptionCacheService subscriptionService;
    private final ApiKeyMapper apiKeyMapper;
    private final DeployerFactory deployerFactory;
    private final ThreadPoolExecutor syncFetcherExecutor;
    private final ThreadPoolExecutor syncDeployerExecutor;

    @Override
    public Completable synchronize(Long from, Long to, List<String> environments) {
        if (from == -1L) {
            return Completable.complete();
        }
        AtomicLong launchTime = new AtomicLong();
        return this.apiKeyFetcher.fetchLatest(from, to).subscribeOn(Schedulers.from((Executor)this.syncFetcherExecutor)).flatMap(apiKeys -> Flowable.just((Object)apiKeys).flatMapIterable(s -> s).flatMap(apiKey -> Flowable.fromIterable((Iterable)apiKey.getSubscriptions()).map(subscriptionId -> this.apiKeyMapper.to((io.gravitee.repository.management.model.ApiKey)apiKey, this.subscriptionService.getById(subscriptionId)))).map(apiKey -> SingleApiKeyDeployable.builder().apiKey((ApiKey)apiKey).syncAction(apiKey.isActive() ? SyncAction.DEPLOY : SyncAction.UNDEPLOY).build())).compose(upstream -> {
            ApiKeyDeployer apiKeyDeployer = this.deployerFactory.createApiKeyDeployer();
            return upstream.parallel(this.syncDeployerExecutor.getMaximumPoolSize()).runOn(Schedulers.from((Executor)this.syncDeployerExecutor)).flatMap(deployable -> {
                if (deployable.syncAction() == SyncAction.DEPLOY) {
                    return this.deploy(apiKeyDeployer, (SingleApiKeyDeployable)deployable);
                }
                if (deployable.syncAction() == SyncAction.UNDEPLOY) {
                    return this.undeploy(apiKeyDeployer, (SingleApiKeyDeployable)deployable);
                }
                return Flowable.empty();
            }).sequential();
        }).count().doOnSubscribe(disposable -> launchTime.set(Instant.now().toEpochMilli())).doOnSuccess(count -> log.debug("ApiKeys of {} apis refreshed in {}ms", count, (Object)(System.currentTimeMillis() - launchTime.get()))).ignoreElement();
    }

    private Flowable<SingleApiKeyDeployable> deploy(ApiKeyDeployer apiKeyDeployer, SingleApiKeyDeployable deployable) {
        return apiKeyDeployer.deploy(deployable).andThen((CompletableSource)apiKeyDeployer.doAfterDeployment(deployable)).andThen((Publisher)Flowable.just((Object)deployable));
    }

    private Flowable<SingleApiKeyDeployable> undeploy(ApiKeyDeployer apiKeyDeployer, SingleApiKeyDeployable deployable) {
        return apiKeyDeployer.undeploy(deployable).andThen((CompletableSource)apiKeyDeployer.doAfterUndeployment(deployable)).andThen((Publisher)Flowable.just((Object)deployable));
    }

    @Override
    public int order() {
        return 40;
    }

    @Generated
    public ApiKeySynchronizer(ApiKeyFetcher apiKeyFetcher, SubscriptionCacheService subscriptionService, ApiKeyMapper apiKeyMapper, DeployerFactory deployerFactory, ThreadPoolExecutor syncFetcherExecutor, ThreadPoolExecutor syncDeployerExecutor) {
        this.apiKeyFetcher = apiKeyFetcher;
        this.subscriptionService = subscriptionService;
        this.apiKeyMapper = apiKeyMapper;
        this.deployerFactory = deployerFactory;
        this.syncFetcherExecutor = syncFetcherExecutor;
        this.syncDeployerExecutor = syncDeployerExecutor;
    }
}

