/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.synchronizer.api;

import io.gravitee.gateway.services.sync.process.common.model.SyncException;
import io.gravitee.gateway.services.sync.process.repository.mapper.SubscriptionMapper;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiReactorDeployable;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.api.search.Order;
import io.gravitee.repository.management.api.search.SubscriptionCriteria;
import io.gravitee.repository.management.api.search.builder.SortableBuilder;
import io.gravitee.repository.management.model.Subscription;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionAppender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubscriptionAppender.class);
    private static final List<String> INITIAL_STATUS = List.of(Subscription.Status.ACCEPTED.name());
    private static final List<String> INCREMENTAL_STATUS = List.of(Subscription.Status.ACCEPTED.name(), Subscription.Status.CLOSED.name(), Subscription.Status.PAUSED.name(), Subscription.Status.PENDING.name());
    private final SubscriptionRepository subscriptionRepository;
    private final SubscriptionMapper subscriptionMapper;

    public List<ApiReactorDeployable> appends(boolean initialSync, List<ApiReactorDeployable> deployables) {
        Map<String, ApiReactorDeployable> deployableByApi = deployables.stream().collect(Collectors.toMap(ApiReactorDeployable::apiId, d -> d));
        List<String> allPlans = deployableByApi.values().stream().map(ApiReactorDeployable::subscribablePlans).flatMap(Collection::stream).collect(Collectors.toList());
        if (!allPlans.isEmpty()) {
            Map<String, List<io.gravitee.gateway.api.service.Subscription>> subscriptionsByApi = this.loadSubscriptions(initialSync, allPlans);
            subscriptionsByApi.forEach((api, subscriptions) -> {
                ApiReactorDeployable deployable = (ApiReactorDeployable)deployableByApi.get(api);
                deployable.subscriptions((List)subscriptions);
            });
        }
        return deployables;
    }

    protected Map<String, List<io.gravitee.gateway.api.service.Subscription>> loadSubscriptions(boolean initialSync, List<String> plans) {
        SubscriptionCriteria.SubscriptionCriteriaBuilder criteriaBuilder = SubscriptionCriteria.builder().plans(plans);
        if (initialSync) {
            criteriaBuilder.statuses(INITIAL_STATUS).endingAtAfter(Instant.now().toEpochMilli()).includeWithoutEnd(true);
        } else {
            criteriaBuilder.statuses(INCREMENTAL_STATUS);
        }
        try {
            return this.subscriptionRepository.search(criteriaBuilder.build(), new SortableBuilder().field("updatedAt").order(Order.ASC).build()).stream().map(subscription -> {
                io.gravitee.gateway.api.service.Subscription subscriptionConverted = this.subscriptionMapper.to((Subscription)subscription);
                if (subscriptionConverted != null) {
                    subscriptionConverted.setForceDispatch(true);
                }
                return subscriptionConverted;
            }).filter(Objects::nonNull).collect(Collectors.groupingBy(io.gravitee.gateway.api.service.Subscription::getApi));
        }
        catch (Exception ex) {
            throw new SyncException("Error occurred when retrieving subscriptions", ex);
        }
    }

    @Generated
    public SubscriptionAppender(SubscriptionRepository subscriptionRepository, SubscriptionMapper subscriptionMapper) {
        this.subscriptionRepository = subscriptionRepository;
        this.subscriptionMapper = subscriptionMapper;
    }
}

