/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.synchronizer.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.gateway.env.GatewayConfiguration;
import io.gravitee.gateway.reactor.ReactableApi;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiReactorDeployable;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.model.Plan;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanAppender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlanAppender.class);
    private final ObjectMapper objectMapper;
    private final PlanRepository planRepository;
    private final GatewayConfiguration gatewayConfiguration;

    public List<ApiReactorDeployable> appends(List<ApiReactorDeployable> deployables) {
        List<ApiReactorDeployable> v1ApiDeployables = deployables.stream().filter(deployable -> deployable.reactableApi().getDefinitionVersion() == DefinitionVersion.V1).collect(Collectors.toList());
        this.fetchV1ApiPlans(v1ApiDeployables);
        return deployables.stream().map(deployable -> {
            ReactableApi<?> reactableApi = deployable.reactableApi();
            if (reactableApi.getDefinitionVersion() != DefinitionVersion.V4) {
                this.filterPlanForApiV2(reactableApi);
            } else {
                this.filterPlanForApiV4(reactableApi);
            }
            return deployable;
        }).filter(deployable -> {
            ReactableApi<?> reactableApi = deployable.reactableApi();
            if (reactableApi.getDefinition() instanceof Api) {
                Api v4definition = (Api)reactableApi.getDefinition();
                return v4definition.getPlans() != null && !v4definition.getPlans().isEmpty();
            }
            if (reactableApi.getDefinition() instanceof io.gravitee.definition.model.Api) {
                return !((io.gravitee.definition.model.Api)reactableApi.getDefinition()).getPlans().isEmpty();
            }
            return false;
        }).collect(Collectors.toList());
    }

    private void fetchV1ApiPlans(List<ApiReactorDeployable> deployables) {
        Map<String, io.gravitee.gateway.handlers.api.definition.Api> apiById = deployables.stream().map(deployable -> (io.gravitee.gateway.handlers.api.definition.Api)deployable.reactableApi()).collect(Collectors.toMap(io.gravitee.gateway.handlers.api.definition.Api::getId, api -> api));
        ArrayList<String> apiV1Ids = new ArrayList<String>(apiById.keySet());
        try {
            Map<String, List<io.gravitee.repository.management.model.Plan>> plansByApi = this.planRepository.findByApis(apiV1Ids).stream().collect(Collectors.groupingBy(io.gravitee.repository.management.model.Plan::getApi));
            plansByApi.forEach((apiId, plans) -> {
                io.gravitee.gateway.handlers.api.definition.Api api = (io.gravitee.gateway.handlers.api.definition.Api)apiById.get(apiId);
                ((io.gravitee.definition.model.Api)api.getDefinition()).setPlans(plans.stream().filter(plan -> Plan.Status.PUBLISHED.equals((Object)plan.getStatus()) || Plan.Status.DEPRECATED.equals((Object)plan.getStatus())).map(this::convert).collect(Collectors.toList()));
            });
        }
        catch (TechnicalException te) {
            log.error("Unexpected error while loading plans of APIs: [{}]", apiV1Ids, (Object)te);
        }
    }

    private Plan convert(io.gravitee.repository.management.model.Plan repoPlan) {
        Plan plan = new Plan();
        plan.setId(repoPlan.getId());
        plan.setName(repoPlan.getName());
        plan.setSecurityDefinition(repoPlan.getSecurityDefinition());
        plan.setSelectionRule(repoPlan.getSelectionRule());
        plan.setTags(repoPlan.getTags());
        plan.setStatus(repoPlan.getStatus().name());
        plan.setApi(repoPlan.getApi());
        if (repoPlan.getSecurity() != null) {
            plan.setSecurity(repoPlan.getSecurity().name());
        } else {
            plan.setSecurity("api_key");
        }
        try {
            if (repoPlan.getDefinition() != null && !repoPlan.getDefinition().trim().isEmpty()) {
                HashMap paths = (HashMap)this.objectMapper.readValue(repoPlan.getDefinition(), (TypeReference)new TypeReference<HashMap<String, List<Rule>>>(){});
                plan.setPaths((Map)paths);
            }
        }
        catch (IOException ioe) {
            log.error("Unexpected error while converting plan: {}", (Object)plan, (Object)ioe);
        }
        return plan;
    }

    private void filterPlanForApiV2(ReactableApi<?> reactableApi) {
        io.gravitee.definition.model.Api apiDefinition = (io.gravitee.definition.model.Api)reactableApi.getDefinition();
        List plans = apiDefinition.getPlans();
        if (plans != null) {
            apiDefinition.setPlans(plans.stream().filter(p -> p.getStatus() != null).filter(p -> this.filterPlanStatus(p.getStatus())).filter(p -> this.filterShardingTag(p.getName(), reactableApi.getName(), p.getTags())).collect(Collectors.toList()));
        }
    }

    private void filterPlanForApiV4(ReactableApi<?> reactableApi) {
        Api apiDefinition = (Api)reactableApi.getDefinition();
        List plans = apiDefinition.getPlans();
        if (plans != null) {
            apiDefinition.setPlans(plans.stream().filter(p -> p.getStatus() != null).filter(p -> this.filterPlanStatus(p.getStatus().getLabel())).filter(p -> this.filterShardingTag(p.getName(), reactableApi.getName(), p.getTags())).collect(Collectors.toList()));
        }
    }

    private boolean filterPlanStatus(String planStatus) {
        return PlanStatus.PUBLISHED.getLabel().equalsIgnoreCase(planStatus) || PlanStatus.DEPRECATED.getLabel().equalsIgnoreCase(planStatus);
    }

    protected boolean filterShardingTag(String planName, String apiName, Set<String> tags) {
        if (tags != null && !tags.isEmpty()) {
            boolean hasMatchingTags = this.gatewayConfiguration.hasMatchingTags(tags);
            if (!hasMatchingTags) {
                log.debug("Plan name[{}] api[{}] has been ignored because not in configured sharding tags", (Object)planName, (Object)apiName);
            }
            return hasMatchingTags;
        }
        return true;
    }

    @Generated
    public PlanAppender(ObjectMapper objectMapper, PlanRepository planRepository, GatewayConfiguration gatewayConfiguration) {
        this.objectMapper = objectMapper;
        this.planRepository = planRepository;
        this.gatewayConfiguration = gatewayConfiguration;
    }
}

