/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.synchronizer.api;

import io.gravitee.gateway.handlers.api.manager.ApiManager;
import io.gravitee.gateway.services.sync.process.common.deployer.DeployerFactory;
import io.gravitee.gateway.services.sync.process.repository.RepositorySynchronizer;
import io.gravitee.gateway.services.sync.process.repository.fetcher.LatestEventFetcher;
import io.gravitee.gateway.services.sync.process.repository.mapper.ApiMapper;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.AbstractApiSynchronizer;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiKeyAppender;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.PlanAppender;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.SubscriptionAppender;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiSynchronizer
extends AbstractApiSynchronizer
implements RepositorySynchronizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiSynchronizer.class);
    private static final Set<EventType> INIT_EVENT_TYPES = Set.of(EventType.PUBLISH_API, EventType.START_API);
    private static final Set<EventType> INCREMENTAL_EVENT_TYPES = Set.of(EventType.PUBLISH_API, EventType.START_API, EventType.UNPUBLISH_API, EventType.STOP_API);
    private final LatestEventFetcher eventsFetcher;

    public ApiSynchronizer(LatestEventFetcher eventsFetcher, ApiManager apiManager, ApiMapper apiMapper, PlanAppender planAppender, SubscriptionAppender subscriptionAppender, ApiKeyAppender apiKeyAppender, DeployerFactory deployerFactory, ThreadPoolExecutor syncFetcherExecutor, ThreadPoolExecutor syncDeployerExecutor) {
        super(apiManager, apiMapper, planAppender, subscriptionAppender, apiKeyAppender, deployerFactory, syncFetcherExecutor, syncDeployerExecutor);
        this.eventsFetcher = eventsFetcher;
    }

    @Override
    public Completable synchronize(Long from, Long to, List<String> environments) {
        AtomicLong launchTime = new AtomicLong();
        boolean initialSync = from == null || from == -1L;
        return this.eventsFetcher.fetchLatest(from, to, Event.EventProperties.API_ID, environments, initialSync ? INIT_EVENT_TYPES : INCREMENTAL_EVENT_TYPES).subscribeOn(Schedulers.from((Executor)this.syncFetcherExecutor)).rebatchRequests(this.syncFetcherExecutor.getMaximumPoolSize()).compose(eventsFlowable -> this.processEvents(initialSync, (Flowable<List<Event>>)eventsFlowable)).count().doOnSubscribe(disposable -> launchTime.set(Instant.now().toEpochMilli())).doOnSuccess(count -> {
            String logMsg = String.format("%s apis synchronized in %sms", count, System.currentTimeMillis() - launchTime.get());
            if (initialSync) {
                log.info(logMsg);
            } else {
                log.debug(logMsg);
            }
        }).ignoreElement();
    }

    @Override
    protected int bulkEvents() {
        return this.eventsFetcher.bulkItems();
    }

    @Override
    public int order() {
        return 1;
    }
}

