/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.synchronizer.api;

import io.gravitee.gateway.api.service.ApiKey;
import io.gravitee.gateway.api.service.Subscription;
import io.gravitee.gateway.reactor.ReactableApi;
import io.gravitee.gateway.services.sync.process.common.model.ApiKeyDeployable;
import io.gravitee.gateway.services.sync.process.common.model.SubscriptionDeployable;
import io.gravitee.gateway.services.sync.process.common.model.SyncAction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public class ApiReactorDeployable
implements ApiKeyDeployable,
SubscriptionDeployable {
    private String apiId;
    private ReactableApi<?> reactableApi;
    private SyncAction syncAction;
    private List<Subscription> subscriptions;
    private List<ApiKey> apiKeys;
    private Set<String> subscribablePlans;
    private Set<String> apiKeyPlans;

    @Override
    public String id() {
        return this.apiId;
    }

    @Override
    public String apiId() {
        if (this.apiId == null) {
            return this.reactableApi.getId();
        }
        return this.apiId;
    }

    @Override
    public Set<String> subscribablePlans() {
        if (this.subscribablePlans == null) {
            Set reactableApiSubscribablePlans;
            if (this.reactableApi != null && (reactableApiSubscribablePlans = this.reactableApi.getSubscribablePlans()) != null) {
                this.subscribablePlans = new HashSet<String>();
                this.subscribablePlans.addAll(reactableApiSubscribablePlans);
                return this.subscribablePlans;
            }
            return Set.of();
        }
        return this.subscribablePlans;
    }

    @Override
    public Set<String> apiKeyPlans() {
        if (this.apiKeyPlans == null) {
            Set reactableApiApiKeyPlans;
            if (this.reactableApi != null && (reactableApiApiKeyPlans = this.reactableApi.getApiKeyPlans()) != null) {
                this.apiKeyPlans = new HashSet<String>();
                this.apiKeyPlans.addAll(reactableApiApiKeyPlans);
                return this.apiKeyPlans;
            }
            return Set.of();
        }
        return this.apiKeyPlans;
    }

    @Generated
    private static List<Subscription> $default$subscriptions() {
        return List.of();
    }

    @Generated
    private static List<ApiKey> $default$apiKeys() {
        return List.of();
    }

    @Generated
    ApiReactorDeployable(String apiId, ReactableApi<?> reactableApi, SyncAction syncAction, List<Subscription> subscriptions, List<ApiKey> apiKeys, Set<String> subscribablePlans, Set<String> apiKeyPlans) {
        this.apiId = apiId;
        this.reactableApi = reactableApi;
        this.syncAction = syncAction;
        this.subscriptions = subscriptions;
        this.apiKeys = apiKeys;
        this.subscribablePlans = subscribablePlans;
        this.apiKeyPlans = apiKeyPlans;
    }

    @Generated
    public static ApiReactorDeployableBuilder builder() {
        return new ApiReactorDeployableBuilder();
    }

    @Generated
    public ReactableApi<?> reactableApi() {
        return this.reactableApi;
    }

    @Override
    @Generated
    public SyncAction syncAction() {
        return this.syncAction;
    }

    @Override
    @Generated
    public List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    @Override
    @Generated
    public List<ApiKey> apiKeys() {
        return this.apiKeys;
    }

    @Generated
    public ApiReactorDeployable apiId(String apiId) {
        this.apiId = apiId;
        return this;
    }

    @Generated
    public ApiReactorDeployable reactableApi(ReactableApi<?> reactableApi) {
        this.reactableApi = reactableApi;
        return this;
    }

    @Generated
    public ApiReactorDeployable syncAction(SyncAction syncAction) {
        this.syncAction = syncAction;
        return this;
    }

    @Override
    @Generated
    public ApiReactorDeployable subscriptions(List<Subscription> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    @Override
    @Generated
    public ApiReactorDeployable apiKeys(List<ApiKey> apiKeys) {
        this.apiKeys = apiKeys;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiReactorDeployable)) {
            return false;
        }
        ApiReactorDeployable other = (ApiReactorDeployable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiId = this.apiId();
        String other$apiId = other.apiId();
        if (this$apiId == null ? other$apiId != null : !this$apiId.equals(other$apiId)) {
            return false;
        }
        ReactableApi<?> this$reactableApi = this.reactableApi();
        ReactableApi<?> other$reactableApi = other.reactableApi();
        if (this$reactableApi == null ? other$reactableApi != null : !this$reactableApi.equals(other$reactableApi)) {
            return false;
        }
        SyncAction this$syncAction = this.syncAction();
        SyncAction other$syncAction = other.syncAction();
        if (this$syncAction == null ? other$syncAction != null : !((Object)((Object)this$syncAction)).equals((Object)other$syncAction)) {
            return false;
        }
        List<Subscription> this$subscriptions = this.subscriptions();
        List<Subscription> other$subscriptions = other.subscriptions();
        if (this$subscriptions == null ? other$subscriptions != null : !((Object)this$subscriptions).equals(other$subscriptions)) {
            return false;
        }
        List<ApiKey> this$apiKeys = this.apiKeys();
        List<ApiKey> other$apiKeys = other.apiKeys();
        return !(this$apiKeys == null ? other$apiKeys != null : !((Object)this$apiKeys).equals(other$apiKeys));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiReactorDeployable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiId = this.apiId();
        result = result * 59 + ($apiId == null ? 43 : $apiId.hashCode());
        ReactableApi<?> $reactableApi = this.reactableApi();
        result = result * 59 + ($reactableApi == null ? 43 : $reactableApi.hashCode());
        SyncAction $syncAction = this.syncAction();
        result = result * 59 + ($syncAction == null ? 43 : ((Object)((Object)$syncAction)).hashCode());
        List<Subscription> $subscriptions = this.subscriptions();
        result = result * 59 + ($subscriptions == null ? 43 : ((Object)$subscriptions).hashCode());
        List<ApiKey> $apiKeys = this.apiKeys();
        result = result * 59 + ($apiKeys == null ? 43 : ((Object)$apiKeys).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ApiReactorDeployable(apiId=" + this.apiId() + ", reactableApi=" + this.reactableApi() + ", syncAction=" + this.syncAction() + ", subscriptions=" + this.subscriptions() + ", apiKeys=" + this.apiKeys() + ", subscribablePlans=" + this.subscribablePlans() + ", apiKeyPlans=" + this.apiKeyPlans() + ")";
    }

    @Generated
    public static class ApiReactorDeployableBuilder {
        @Generated
        private String apiId;
        @Generated
        private ReactableApi<?> reactableApi;
        @Generated
        private SyncAction syncAction;
        @Generated
        private boolean subscriptions$set;
        @Generated
        private List<Subscription> subscriptions$value;
        @Generated
        private boolean apiKeys$set;
        @Generated
        private List<ApiKey> apiKeys$value;
        @Generated
        private Set<String> subscribablePlans;
        @Generated
        private Set<String> apiKeyPlans;

        @Generated
        ApiReactorDeployableBuilder() {
        }

        @Generated
        public ApiReactorDeployableBuilder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        @Generated
        public ApiReactorDeployableBuilder reactableApi(ReactableApi<?> reactableApi) {
            this.reactableApi = reactableApi;
            return this;
        }

        @Generated
        public ApiReactorDeployableBuilder syncAction(SyncAction syncAction) {
            this.syncAction = syncAction;
            return this;
        }

        @Generated
        public ApiReactorDeployableBuilder subscriptions(List<Subscription> subscriptions) {
            this.subscriptions$value = subscriptions;
            this.subscriptions$set = true;
            return this;
        }

        @Generated
        public ApiReactorDeployableBuilder apiKeys(List<ApiKey> apiKeys) {
            this.apiKeys$value = apiKeys;
            this.apiKeys$set = true;
            return this;
        }

        @Generated
        public ApiReactorDeployableBuilder subscribablePlans(Set<String> subscribablePlans) {
            this.subscribablePlans = subscribablePlans;
            return this;
        }

        @Generated
        public ApiReactorDeployableBuilder apiKeyPlans(Set<String> apiKeyPlans) {
            this.apiKeyPlans = apiKeyPlans;
            return this;
        }

        @Generated
        public ApiReactorDeployable build() {
            List<Subscription> subscriptions$value = this.subscriptions$value;
            if (!this.subscriptions$set) {
                subscriptions$value = ApiReactorDeployable.$default$subscriptions();
            }
            List<ApiKey> apiKeys$value = this.apiKeys$value;
            if (!this.apiKeys$set) {
                apiKeys$value = ApiReactorDeployable.$default$apiKeys();
            }
            return new ApiReactorDeployable(this.apiId, this.reactableApi, this.syncAction, subscriptions$value, apiKeys$value, this.subscribablePlans, this.apiKeyPlans);
        }

        @Generated
        public String toString() {
            return "ApiReactorDeployable.ApiReactorDeployableBuilder(apiId=" + this.apiId + ", reactableApi=" + this.reactableApi + ", syncAction=" + this.syncAction + ", subscriptions$value=" + this.subscriptions$value + ", apiKeys$value=" + this.apiKeys$value + ", subscribablePlans=" + this.subscribablePlans + ", apiKeyPlans=" + this.apiKeyPlans + ")";
        }
    }
}

