/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.service;

import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiReactorDeployable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class PlanService {
    private final Map<String, Set<String>> plansPerApi = new ConcurrentHashMap<String, Set<String>>();

    public void register(ApiReactorDeployable apiReactorDeployable) {
        if (apiReactorDeployable != null && apiReactorDeployable.apiId() != null) {
            this.plansPerApi.put(apiReactorDeployable.apiId(), apiReactorDeployable.subscribablePlans());
        }
    }

    public void unregister(ApiReactorDeployable apiReactorDeployable) {
        if (apiReactorDeployable != null && apiReactorDeployable.apiId() != null) {
            this.plansPerApi.remove(apiReactorDeployable.apiId());
        }
    }

    public boolean isDeployed(String apiId, String planId) {
        return Optional.ofNullable(this.plansPerApi.get(apiId)).map(strings -> strings.contains(planId)).orElse(false);
    }

    @Generated
    public PlanService() {
    }
}

