/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.gateway.dictionary.model.Dictionary;
import io.gravitee.repository.management.model.Event;
import io.reactivex.rxjava3.core.Maybe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DictionaryMapper.class);
    private final ObjectMapper objectMapper;

    public Maybe<Dictionary> to(Event dictionaryEvent) {
        return Maybe.fromCallable(() -> {
            try {
                return (Dictionary)this.objectMapper.readValue(dictionaryEvent.getPayload(), Dictionary.class);
            }
            catch (Exception e) {
                log.warn("Error while determining deployed dictionaries into events payload", (Throwable)e);
                return null;
            }
        });
    }

    public Maybe<String> toId(Event dictionaryEvent) {
        return Maybe.fromCallable(() -> {
            String dictionaryId = null;
            if (dictionaryEvent.getProperties() != null) {
                dictionaryId = (String)dictionaryEvent.getProperties().get(Event.EventProperties.DICTIONARY_ID.getValue());
            }
            if (dictionaryId == null) {
                log.warn("Unable to extract dictionary info from event [{}].", (Object)dictionaryEvent.getId());
            }
            return dictionaryId;
        });
    }

    @Generated
    public DictionaryMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

