/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.gateway.reactor.ReactableApi;
import io.gravitee.gateway.services.sync.process.repository.service.EnvironmentService;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.LifecycleState;
import io.reactivex.rxjava3.core.Maybe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMapper.class);
    private final ObjectMapper objectMapper;
    private final EnvironmentService environmentService;

    public Maybe<String> toId(Event apiEvent) {
        return Maybe.fromCallable(() -> {
            String apiId = null;
            if (apiEvent.getProperties() != null) {
                apiId = (String)apiEvent.getProperties().get(Event.EventProperties.API_ID.getValue());
            }
            if (apiId == null) {
                log.warn("Unable to extract api info from event [{}].", (Object)apiEvent.getId());
            }
            return apiId;
        });
    }

    public Maybe<ReactableApi<?>> to(Event apiEvent) {
        return Maybe.fromCallable(() -> {
            try {
                io.gravitee.gateway.handlers.api.definition.Api reactableApi;
                io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)this.objectMapper.readValue(apiEvent.getPayload(), io.gravitee.repository.management.model.Api.class);
                if (DefinitionVersion.V4 != api.getDefinitionVersion()) {
                    io.gravitee.definition.model.Api eventApiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
                    reactableApi = new io.gravitee.gateway.handlers.api.definition.Api(eventApiDefinition);
                } else {
                    Api eventApiDefinition = (Api)this.objectMapper.readValue(api.getDefinition(), Api.class);
                    reactableApi = new io.gravitee.gateway.reactive.handlers.api.v4.Api(eventApiDefinition);
                }
                reactableApi.setEnabled(api.getLifecycleState() == LifecycleState.STARTED);
                reactableApi.setDeployedAt(apiEvent.getCreatedAt());
                this.environmentService.fill(api.getEnvironmentId(), (ReactableApi<?>)reactableApi);
                return reactableApi;
            }
            catch (Exception e) {
                log.error("Unable to extract api definition from event [{}].", (Object)apiEvent.getId(), (Object)e);
                return null;
            }
        });
    }

    @Generated
    public ApiMapper(ObjectMapper objectMapper, EnvironmentService environmentService) {
        this.objectMapper = objectMapper;
        this.environmentService = environmentService;
    }
}

